/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.HideableElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugOverlay
implements Renderable,
class_6379,
class_4069 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final List<DebugOverlayLine> lines = new ArrayList<DebugOverlayLine>();
    @NotNull
    protected Supplier<Integer> topYOffsetSupplier = () -> 0;
    @NotNull
    protected Supplier<Integer> bottomYOffsetSupplier = () -> 0;
    @NotNull
    protected class_327 font;
    protected int lineSpacerHeight;
    protected int lineBorderWidth;
    @NotNull
    protected DrawableColor lineBackgroundColor;
    @NotNull
    protected DrawableColor lineTextColor;
    protected boolean lineTextShadow;
    protected List<AbstractElement> currentScreenElements;
    @Nullable
    protected ContextMenu rightClickMenu;
    protected final List<class_364> children;
    public boolean allowRender;

    public DebugOverlay() {
        this.font = class_310.method_1551().field_1772;
        this.lineSpacerHeight = 2;
        this.lineBorderWidth = 2;
        this.lineBackgroundColor = DrawableColor.of(new Color(0, 0, 0, 230));
        this.lineTextColor = DrawableColor.WHITE;
        this.lineTextShadow = true;
        this.currentScreenElements = new ArrayList<AbstractElement>();
        this.rightClickMenu = null;
        this.children = new ArrayList<class_364>();
        this.allowRender = false;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!this.allowRender) {
            return;
        }
        if (class_310.method_1551().field_1755 == null) {
            return;
        }
        this.renderWidgetOverlays(graphics, class_310.method_1551().field_1755, mouseX, mouseY, partial);
        int leftX = 0;
        int rightX = class_310.method_1551().field_1755.field_22789;
        int topLeftY = this.topYOffsetSupplier.get();
        int topRightY = this.topYOffsetSupplier.get();
        int bottomLeftY = this.bottomYOffsetSupplier.get();
        int bottomRightY = this.bottomYOffsetSupplier.get();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        graphics.pose().method_22903();
        graphics.pose().method_22904(0.0, 0.0, 400.0);
        for (DebugOverlayLine line : this.lines) {
            boolean isLeft = line.linePosition == LinePosition.TOP_LEFT || line.linePosition == LinePosition.BOTTOM_LEFT;
            class_2561 text = line.textSupplier.get(line);
            int width = this.font.method_27525((class_5348)text) + this.lineBorderWidth * 2;
            Objects.requireNonNull(this.font);
            int height = 9 + this.lineSpacerHeight * 2;
            if (line instanceof DebugOverlaySpacerLine) {
                DebugOverlaySpacerLine s = (DebugOverlaySpacerLine)line;
                height = s.height;
            }
            int x = isLeft ? leftX : rightX - width;
            int y = topLeftY;
            if (line.linePosition == LinePosition.TOP_RIGHT) {
                y = topRightY;
            }
            if (line.linePosition == LinePosition.BOTTOM_LEFT) {
                y = bottomLeftY;
            }
            if (line.linePosition == LinePosition.BOTTOM_RIGHT) {
                y = bottomRightY;
            }
            line.lastX = x;
            line.lastY = y;
            line.lastWidth = width;
            line.lastHeight = height;
            line.hovered = line.isMouseOver(mouseX, mouseY);
            if (!(line instanceof DebugOverlaySpacerLine)) {
                this.renderLineBackground(graphics, x, y, width, height);
                graphics.drawString(this.font, text, x + this.lineBorderWidth, y + this.lineSpacerHeight, this.lineTextColor.getColorInt(), this.lineTextShadow);
            }
            if (line.linePosition == LinePosition.TOP_LEFT) {
                topLeftY += height;
            }
            if (line.linePosition == LinePosition.TOP_RIGHT) {
                topRightY += height;
            }
            if (line.linePosition == LinePosition.BOTTOM_LEFT) {
                bottomLeftY -= height;
            }
            if (line.linePosition != LinePosition.BOTTOM_RIGHT) continue;
            bottomRightY -= height;
        }
        graphics.pose().method_22909();
        RenderSystem.disableDepthTest();
        RenderingUtils.resetShaderColor(graphics);
        if (CustomizationOverlay.getCurrentMenuBarInstance() != null && CustomizationOverlay.getCurrentMenuBarInstance().isEntryContextMenuOpen()) {
            this.closeRightClickContextMenu();
        }
        if (this.rightClickMenu != null) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.pose().method_22903();
            graphics.pose().method_22904(0.0, 0.0, 500.0);
            this.rightClickMenu.render(graphics, mouseX, mouseY, partial);
            graphics.pose().method_22909();
            RenderSystem.disableDepthTest();
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderWidgetOverlays(@NotNull GuiGraphics graphics, @NotNull class_437 current, int mouseX, int mouseY, float partial) {
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
        if (layer == null) {
            return;
        }
        this.currentScreenElements.clear();
        if (!ScreenCustomization.isCustomizationEnabledForScreen(current)) {
            return;
        }
        ArrayList<VanillaWidgetElement> widgets = new ArrayList<VanillaWidgetElement>(layer.vanillaWidgetElements);
        for (AbstractElement abstractElement : widgets) {
            HideableElement h;
            if (abstractElement instanceof HideableElement && (h = (HideableElement)((Object)abstractElement)).isHidden()) continue;
            this.currentScreenElements.add(abstractElement);
            UIBase.renderBorder(graphics, abstractElement.getAbsoluteX(), abstractElement.getAbsoluteY(), abstractElement.getAbsoluteX() + abstractElement.getAbsoluteWidth(), abstractElement.getAbsoluteY() + abstractElement.getAbsoluteHeight(), 1, UIBase.getUIColorTheme().layout_editor_element_border_color_normal, true, true, true, true);
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderLineBackground(@NotNull GuiGraphics graphics, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        graphics.fill(x, y, x + width, y + height, this.lineBackgroundColor.getColorInt());
        RenderingUtils.resetShaderColor(graphics);
    }

    public DebugOverlay setLineTextShadow(boolean shadow) {
        this.lineTextShadow = shadow;
        return this;
    }

    public DebugOverlay setLineTextColor(@NotNull DrawableColor color) {
        this.lineTextColor = color;
        return this;
    }

    public DebugOverlay setLineBackgroundColor(@NotNull DrawableColor color) {
        this.lineBackgroundColor = color;
        return this;
    }

    public DebugOverlay setLineBorderWidth(int width) {
        this.lineBorderWidth = width;
        return this;
    }

    public DebugOverlay setLineSpacerHeight(int height) {
        this.lineSpacerHeight = height;
        return this;
    }

    public DebugOverlay setFont(@NotNull class_327 font) {
        this.font = font;
        return this;
    }

    public DebugOverlay setTopYOffsetSupplier(@NotNull Supplier<Integer> yOffsetSupplier) {
        this.topYOffsetSupplier = yOffsetSupplier;
        return this;
    }

    public DebugOverlay setBottomYOffsetSupplier(@NotNull Supplier<Integer> yOffsetSupplier) {
        this.bottomYOffsetSupplier = yOffsetSupplier;
        return this;
    }

    public DebugOverlaySpacerLine addSpacerLine(@NotNull String identifier, @NotNull LinePosition position, int height) {
        return (DebugOverlaySpacerLine)this.addLine(new DebugOverlaySpacerLine(identifier, height)).setPosition(position);
    }

    public DebugOverlaySpacerLine addSpacerLineBefore(@NotNull String addBeforeIdentifier, @NotNull String identifier, @NotNull LinePosition position, int height) {
        return (DebugOverlaySpacerLine)this.addLineBefore(addBeforeIdentifier, new DebugOverlaySpacerLine(identifier, height).setPosition(position));
    }

    public DebugOverlaySpacerLine addSpacerLineAfter(@NotNull String addAfterIdentifier, @NotNull String identifier, @NotNull LinePosition position, int height) {
        return (DebugOverlaySpacerLine)this.addLineAfter(addAfterIdentifier, new DebugOverlaySpacerLine(identifier, height).setPosition(position));
    }

    public DebugOverlaySpacerLine addSpacerLineAt(int index, @NotNull String identifier, @NotNull LinePosition position, int height) {
        return (DebugOverlaySpacerLine)this.addLineAt(index, new DebugOverlaySpacerLine(identifier, height).setPosition(position));
    }

    public DebugOverlayLine addLine(@NotNull String identifier, @NotNull LinePosition position, @NotNull ConsumingSupplier<DebugOverlayLine, class_2561> textSupplier) {
        return this.addLine(new DebugOverlayLine(identifier).setTextSupplier(textSupplier).setPosition(position));
    }

    public DebugOverlayLine addLineBefore(@NotNull String addBeforeIdentifier, @NotNull String identifier, @NotNull LinePosition position, @NotNull ConsumingSupplier<DebugOverlayLine, class_2561> textSupplier) {
        return this.addLineBefore(addBeforeIdentifier, new DebugOverlayLine(identifier).setTextSupplier(textSupplier).setPosition(position));
    }

    public DebugOverlayLine addLineAfter(@NotNull String addAfterIdentifier, @NotNull String identifier, @NotNull LinePosition position, @NotNull ConsumingSupplier<DebugOverlayLine, class_2561> textSupplier) {
        return this.addLineAfter(addAfterIdentifier, new DebugOverlayLine(identifier).setTextSupplier(textSupplier).setPosition(position));
    }

    public DebugOverlayLine addLineAt(int index, @NotNull String identifier, @NotNull LinePosition position, @NotNull ConsumingSupplier<DebugOverlayLine, class_2561> textSupplier) {
        return this.addLineAt(index, new DebugOverlayLine(identifier).setTextSupplier(textSupplier).setPosition(position));
    }

    public <T extends DebugOverlayLine> T addLineBefore(@NotNull String addBeforeIdentifier, @NotNull T line) {
        if (this.lineExists(line.identifier)) {
            throw new RuntimeException("[FANCYMENU] Line identifier already exists: " + line.identifier);
        }
        DebugOverlayLine target = this.getLine(addBeforeIdentifier);
        int index = this.indexOfLine(addBeforeIdentifier);
        if (index == -1) {
            index = this.lines.size();
        }
        return (T)this.addLineAt(index, line.setPosition(target != null ? target.linePosition : LinePosition.TOP_LEFT));
    }

    public <T extends DebugOverlayLine> T addLineAfter(@NotNull String addAfterIdentifier, @NotNull T line) {
        if (this.lineExists(line.identifier)) {
            throw new RuntimeException("[FANCYMENU] Line identifier already exists: " + line.identifier);
        }
        DebugOverlayLine target = this.getLine(addAfterIdentifier);
        int index = this.indexOfLine(addAfterIdentifier) + 1;
        if (index == 0) {
            index = this.lines.size();
        }
        return (T)this.addLineAt(index, line.setPosition(target != null ? target.linePosition : LinePosition.TOP_LEFT));
    }

    public <T extends DebugOverlayLine> T addLineAt(int index, @NotNull T line) {
        if (this.lineExists(line.identifier)) {
            throw new RuntimeException("[FANCYMENU] Line identifier already exists: " + line.identifier);
        }
        this.lines.add(Math.min(this.lines.size(), Math.max(0, index)), line);
        return line;
    }

    public <T extends DebugOverlayLine> T addLine(@NotNull T line) {
        if (this.lineExists(line.identifier)) {
            throw new RuntimeException("[FANCYMENU] Line identifier already exists: " + line.identifier);
        }
        this.lines.add(line);
        return line;
    }

    public void removeLine(@NotNull String identifier) {
        DebugOverlayLine line = this.getLine(identifier);
        if (line != null) {
            this.lines.remove(line);
        }
    }

    @Nullable
    public DebugOverlayLine getLine(@NotNull String identifier) {
        for (DebugOverlayLine line : this.lines) {
            if (!line.identifier.equals(identifier)) continue;
            return line;
        }
        return null;
    }

    public int indexOfLine(@NotNull String identifier) {
        DebugOverlayLine line = this.getLine(identifier);
        if (line != null) {
            return this.lines.indexOf(line);
        }
        return -1;
    }

    public boolean lineExists(@NotNull String identifier) {
        return this.getLine(identifier) != null;
    }

    public DebugOverlay resetOverlay() {
        this.lines.forEach(line -> {
            line.hovered = false;
        });
        this.closeRightClickContextMenu();
        return this;
    }

    public DebugOverlay openRightClickContextMenu(@NotNull ContextMenu menu) {
        this.closeRightClickContextMenu();
        this.rightClickMenu = Objects.requireNonNull(menu);
        this.children.add(0, this.rightClickMenu);
        this.rightClickMenu.openMenuAtMouse();
        return this;
    }

    public DebugOverlay closeRightClickContextMenu() {
        if (this.rightClickMenu != null) {
            this.rightClickMenu.closeMenu();
            this.children.remove(this.rightClickMenu);
            this.rightClickMenu = null;
        }
        return this;
    }

    @NotNull
    protected ContextMenu buildContextMenuForElement(@NotNull AbstractElement element) {
        Objects.requireNonNull(element);
        ContextMenu menu = new ContextMenu();
        if (element instanceof VanillaWidgetElement) {
            VanillaWidgetElement v = (VanillaWidgetElement)element;
            ((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("copy_vanilla_widget_locator", (class_2561)Components.translatable("fancymenu.helper.editor.items.vanilla_button.copy_locator", new Object[0]), (menu1, entry) -> {
                if (v.widgetMeta != null) {
                    class_310.method_1551().field_1774.method_1455(v.widgetMeta.getLocator());
                }
                MainThreadTaskExecutor.executeInMainThread(() -> this.closeRightClickContextMenu(), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.items.vanilla_button.copy_locator.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("notes"));
        }
        ((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("copy_id", (class_2561)Components.translatable("fancymenu.helper.editor.items.copyid", new Object[0]), (menu1, entry) -> {
            class_310.method_1551().field_1774.method_1455(element.getInstanceIdentifier());
            MainThreadTaskExecutor.executeInMainThread(() -> this.closeRightClickContextMenu(), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.items.copyid.btn.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("notes"));
        return menu;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        this.closeRightClickContextMenu();
        for (DebugOverlayLine line : this.lines) {
            if (!line.onClick(button, (int)mouseX, (int)mouseY)) continue;
            return true;
        }
        if (button == 1) {
            for (AbstractElement e : this.currentScreenElements) {
                if (!RenderingUtils.isXYInArea(mouseX, mouseY, (double)e.getAbsoluteX(), (double)e.getAbsoluteY(), (double)e.getAbsoluteWidth(), (double)e.getAbsoluteHeight())) continue;
                this.openRightClickContextMenu(this.buildContextMenuForElement(e));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }

    public List<class_364> method_25396() {
        return this.children;
    }

    public boolean method_25397() {
        return false;
    }

    public void method_25398(boolean var1) {
    }

    @Nullable
    public class_364 method_25399() {
        return null;
    }

    public void method_25395(@Nullable class_364 var1) {
    }

    public static class DebugOverlayLine {
        protected final String identifier;
        @NotNull
        protected LinePosition linePosition = LinePosition.TOP_LEFT;
        @NotNull
        protected ConsumingSupplier<DebugOverlayLine, class_2561> textSupplier = consumes -> Components.empty();
        protected boolean clickable = false;
        @NotNull
        protected Consumer<DebugOverlayLine> clickAction = line -> {};
        protected long lastClicked = -1L;
        protected int lastX;
        protected int lastY;
        protected int lastWidth;
        protected int lastHeight;
        protected boolean hovered = false;

        protected DebugOverlayLine(@NotNull String identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        public DebugOverlayLine setPosition(@NotNull LinePosition position) {
            this.linePosition = position;
            return this;
        }

        @NotNull
        public LinePosition getPosition() {
            return this.linePosition;
        }

        public DebugOverlayLine setTextSupplier(@NotNull ConsumingSupplier<DebugOverlayLine, class_2561> textSupplier) {
            this.textSupplier = textSupplier;
            return this;
        }

        @NotNull
        public ConsumingSupplier<DebugOverlayLine, class_2561> getTextSupplier() {
            return this.textSupplier;
        }

        public DebugOverlayLine setClickAction(@Nullable Consumer<DebugOverlayLine> clickAction) {
            this.clickable = clickAction != null;
            this.clickAction = clickAction != null ? clickAction : line -> {};
            return this;
        }

        public boolean recentlyClicked() {
            return System.currentTimeMillis() < this.lastClicked + 2000L;
        }

        public boolean isHovered() {
            return this.hovered;
        }

        protected boolean onClick(int button, int mouseX, int mouseY) {
            if (!this.clickable) {
                return false;
            }
            if (this.isMouseOver(mouseX, mouseY) && button == 0) {
                this.clickAction.accept(this);
                this.lastClicked = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        protected boolean isMouseOver(int mouseX, int mouseY) {
            return RenderingUtils.isXYInArea(mouseX, mouseY, this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        }
    }

    public static enum LinePosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static class DebugOverlaySpacerLine
    extends DebugOverlayLine {
        protected final int height;

        protected DebugOverlaySpacerLine(@NotNull String identifier, int height) {
            super(identifier);
            this.height = height;
        }
    }
}

