/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsEntityNearbyRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsEntityNearbyRequirement() {
        super("is_entity_nearby");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if (level != null && player != null) {
                if (value == null || value.trim().isEmpty() || !value.contains(":")) {
                    return false;
                }
                String[] valsRaw = value.split(":", 2);
                int radius = SerializationUtils.deserializeNumber(Integer.class, 1, valsRaw[0]);
                String entityKey = valsRaw[1];
                for (class_1297 entity : IsEntityNearbyRequirement.getEntitiesAroundPlayer((class_1657)player, level, radius)) {
                    class_2960 loc = Services.PLATFORM.getEntityKey(entity.method_5864());
                    if (loc == null || !loc.toString().equals(entityKey)) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", (Throwable)ex);
        }
        return false;
    }

    @NotNull
    private static List<class_1297> getEntitiesAroundPlayer(@NotNull class_1657 player, @NotNull class_638 level, double radius) {
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        class_238 boundingBox = new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        return level.method_8333((class_1297)player, boundingBox, entity -> true);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.world.is_entity_nearby", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_entity_nearby.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.editor.loading_requirement.category.world", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "10:minecraft:pig";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsEntityNearbyValueConfigScreen s = new IsEntityNearbyValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    @NotNull
    private static List<class_2960> getEntityKeys() {
        ArrayList<class_2960> types = new ArrayList<class_2960>();
        try {
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                class_2378.field_11145.method_40295().forEach(biomeHolder -> biomeHolder.method_40229().map(key -> Boolean.valueOf(types.add(key.method_29177())), biome -> ""));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get entity types for 'Is Entity Nearby' loading requirement!", (Throwable)ex);
        }
        return types;
    }

    public static class IsEntityNearbyValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String radius;
        @NotNull
        protected String entityKey;
        protected CellScreen.TextInputCell radiusTextInput;
        protected CellScreen.TextInputCell entityKeyTextInput;
        protected EditBoxSuggestions suggestions;

        protected IsEntityNearbyValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)Components.translatable("fancymenu.editor.elements.visibilityrequirements.edit_value", new Object[0]), callback);
            if (value.contains(":")) {
                this.radius = value.split(":", 2)[0];
                this.entityKey = value.split(":", 2)[1];
            } else {
                this.radius = "10";
                this.entityKey = "minecraft:pig";
            }
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String entityId = this.getEntityKeyString();
            this.addLabelCell((class_2561)Components.translatable("fancymenu.requirements.world.is_entity_nearby.value.key", new Object[0]));
            this.entityKeyTextInput = this.addTextInputCell(null, true, true).setText(entityId);
            ArrayList<String> suggestionValues = new ArrayList<String>();
            IsEntityNearbyRequirement.getEntityKeys().forEach(location -> suggestionValues.add(location.toString()));
            if (suggestionValues.isEmpty()) {
                suggestionValues.add(class_1074.method_4662((String)"fancymenu.requirements.world.is_entity_nearby.suggestions.error", (Object[])new Object[0]));
            }
            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.entityKeyTextInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, suggestionValues);
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            this.entityKeyTextInput.editBox.method_1863(s -> this.suggestions.method_23934());
            this.addCellGroupEndSpacerCell();
            String radiusString = this.getRadiusString();
            this.addLabelCell((class_2561)Components.translatable("fancymenu.requirements.world.is_entity_nearby.value.radius", new Object[0]));
            this.radiusTextInput = this.addTextInputCell(null, true, true).setText(radiusString);
            this.addSpacerCell(20);
        }

        @Override
        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            this.suggestions.method_23923(graphics.pose(), mouseX, mouseY);
        }

        @Override
        public boolean method_25404(int $$0, int $$1, int $$2) {
            if (this.suggestions.method_23924($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25404($$0, $$1, $$2);
        }

        public boolean method_25401(double $$0, double $$1, double scrollDeltaY) {
            if (this.suggestions.method_23921(scrollDeltaY)) {
                return true;
            }
            return super.method_25401($$0, $$1, scrollDeltaY);
        }

        public boolean method_25402(double $$0, double $$1, int $$2) {
            if (this.suggestions.method_23922($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25402($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getRadiusString() + ":" + this.getEntityKeyString();
        }

        @NotNull
        protected String getRadiusString() {
            if (this.radiusTextInput != null) {
                return this.radiusTextInput.getText();
            }
            return this.radius;
        }

        @NotNull
        protected String getEntityKeyString() {
            if (this.entityKeyTextInput != null) {
                return this.entityKeyTextInput.getText();
            }
            return this.entityKey;
        }
    }
}

