/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsTextRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsTextRequirement() {
        super("fancymenu_visibility_requirement_is_text");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            List<String> secStrings = IsTextRequirement.getSections(value);
            if (secStrings.isEmpty()) {
                return false;
            }
            boolean b = true;
            for (String s : secStrings) {
                if (IsTextRequirement.isSectionMet(IsTextRequirement.parseSection(s))) continue;
                b = false;
            }
            return b;
        }
        return false;
    }

    private static boolean isSectionMet(List<String> section) {
        if (!section.isEmpty()) {
            String mode = section.get(0);
            String text = section.get(1);
            String compareWith = section.get(2);
            if (mode.equals("equals")) {
                return text.equals(compareWith);
            }
            if (mode.equals("contains")) {
                return text.contains(compareWith);
            }
            if (mode.equals("starts-with")) {
                return text.startsWith(compareWith);
            }
            if (mode.equals("ends-with")) {
                return text.endsWith(compareWith);
            }
        }
        return false;
    }

    private static List<String> parseSection(String section) {
        ArrayList<String> l = new ArrayList<String>();
        int currentIndex = 0;
        int currentStartIndex = 0;
        String mode = null;
        String text = null;
        String compareWith = null;
        for (char c : section.toCharArray()) {
            String s = String.valueOf(c);
            if (s.equals("\"")) {
                if (currentIndex >= 7 && section.substring(currentIndex - 7).startsWith("\"mode\":\"")) {
                    currentStartIndex = currentIndex + 1;
                }
                if (section.substring(currentIndex).startsWith("\",\"text\":\"")) {
                    mode = section.substring(currentStartIndex, currentIndex);
                }
                if (currentIndex >= 7 && section.substring(currentIndex - 7).startsWith("\"text\":\"")) {
                    currentStartIndex = currentIndex + 1;
                }
                if (section.substring(currentIndex).startsWith("\",\"compare_with\":\"")) {
                    text = section.substring(currentStartIndex, currentIndex);
                }
                if (currentIndex >= 15 && section.substring(currentIndex - 15).startsWith("\"compare_with\":\"")) {
                    currentStartIndex = currentIndex + 1;
                }
                if (section.substring(currentIndex).startsWith("\"]$")) {
                    compareWith = section.substring(currentStartIndex, currentIndex);
                }
            }
            ++currentIndex;
        }
        if (mode != null && text != null && compareWith != null) {
            l.add(mode);
            l.add(text);
            l.add(compareWith);
        }
        return l;
    }

    private static List<String> getSections(String value) {
        ArrayList<String> l = new ArrayList<String>();
        int currentIndex = 0;
        int currentStartIndex = 0;
        for (char c : value.toCharArray()) {
            String s = String.valueOf(c);
            if (s.equals("[") && value.substring(currentIndex).startsWith("[\"mode\":\"")) {
                currentStartIndex = currentIndex;
            }
            if (currentIndex >= 1 && s.equals("]") && value.substring(currentIndex - 1).startsWith("\"]$")) {
                l.add(value.substring(currentStartIndex, currentIndex + 2));
            }
            ++currentIndex;
        }
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.helper.editor.items.visibilityrequirements.is_text", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.items.visibilityrequirements.is_text.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662((String)"fancymenu.helper.editor.items.visibilityrequirements.is_text.valuename", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "[\"mode\":\"...\",\"text\":\"...\",\"compare_with\":\"...\"]$";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsTextValueConfigScreen s = new IsTextValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    public static class IsTextValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected TextCompareMode mode = TextCompareMode.EQUALS;
        @NotNull
        protected String firstText = "";
        @NotNull
        protected String secondText = "";
        protected CellScreen.TextInputCell firstTextCell;
        protected CellScreen.TextInputCell secondTextCell;

        protected IsTextValueConfigScreen(String value, @NotNull Consumer<String> callback) {
            super((class_2561)Components.translatable("fancymenu.helper.editor.items.visibilityrequirements.is_text.valuename", new Object[0]), callback);
            List<String> deserialized;
            List<String> sections;
            if (value == null) {
                value = "";
            }
            if (!(sections = IsTextRequirement.getSections(value)).isEmpty() && !(deserialized = IsTextRequirement.parseSection(sections.get(0))).isEmpty()) {
                TextCompareMode m = TextCompareMode.getByKey(deserialized.get(0));
                if (m != null) {
                    this.mode = m;
                }
                this.firstText = deserialized.get(1);
                this.secondText = deserialized.get(2);
            }
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            LocalizedGenericValueCycle<TextCompareMode> modeCycle = CommonCycles.cycleOrangeValue("fancymenu.loading_requirements.is_text.compare_mode", Arrays.asList(TextCompareMode.values()), this.mode).setValueNameSupplier(mode -> {
                if (mode == TextCompareMode.CONTAINS) {
                    return class_1074.method_4662((String)"fancymenu.loading_requirements.is_text.compare_mode.contains", (Object[])new Object[0]);
                }
                if (mode == TextCompareMode.STARTS_WITH) {
                    return class_1074.method_4662((String)"fancymenu.loading_requirements.is_text.compare_mode.starts_with", (Object[])new Object[0]);
                }
                if (mode == TextCompareMode.ENDS_WITH) {
                    return class_1074.method_4662((String)"fancymenu.loading_requirements.is_text.compare_mode.ends_with", (Object[])new Object[0]);
                }
                return class_1074.method_4662((String)"fancymenu.loading_requirements.is_text.compare_mode.equals", (Object[])new Object[0]);
            });
            this.addCycleButtonCell(modeCycle, true, (value, button) -> {
                this.mode = value;
            });
            this.addCellGroupEndSpacerCell();
            String fText = this.getFirstTextString();
            this.addLabelCell((class_2561)Components.translatable("fancymenu.loading_requirements.is_text.compare_mode.first_text", new Object[0]));
            this.firstTextCell = this.addTextInputCell(null, true, true).setText(fText);
            this.addCellGroupEndSpacerCell();
            String sText = this.getSecondTextString();
            this.addLabelCell((class_2561)Components.translatable("fancymenu.loading_requirements.is_text.compare_mode.second_text", new Object[0]));
            this.secondTextCell = this.addTextInputCell(null, true, true).setText(sText);
            this.addSpacerCell(20);
        }

        @Override
        @NotNull
        public String buildString() {
            return "[\"mode\":\"" + this.mode.key + "\",\"text\":\"" + this.getFirstTextString() + "\",\"compare_with\":\"" + this.getSecondTextString() + "\"]$";
        }

        @NotNull
        protected String getFirstTextString() {
            if (this.firstTextCell != null) {
                return this.firstTextCell.getText();
            }
            return this.firstText;
        }

        @NotNull
        protected String getSecondTextString() {
            if (this.secondTextCell != null) {
                return this.secondTextCell.getText();
            }
            return this.secondText;
        }
    }

    public static enum TextCompareMode {
        EQUALS("equals"),
        CONTAINS("contains"),
        STARTS_WITH("starts-with"),
        ENDS_WITH("ends-with");

        public final String key;

        private TextCompareMode(String key) {
            this.key = key;
        }

        @Nullable
        public static TextCompareMode getByKey(@NotNull String key) {
            for (TextCompareMode mode : TextCompareMode.values()) {
                if (!mode.key.equals(key)) continue;
                return mode;
            }
            return null;
        }
    }
}

