/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements.BuildRequirementGroupScreen;
import de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements.BuildRequirementScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageRequirementsScreen
extends ModernScreen {
    protected LoadingRequirementContainer container;
    protected Consumer<LoadingRequirementContainer> callback;
    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton addRequirementButton;
    protected ExtendedButton addGroupButton;
    protected ExtendedButton editButton;
    protected ExtendedButton removeButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ManageRequirementsScreen(@NotNull LoadingRequirementContainer container, @NotNull Consumer<LoadingRequirementContainer> callback) {
        super((class_2561)Components.translatable("fancymenu.editor.loading_requirement.screens.manage_screen.manage", new Object[0]));
        this.container = container;
        this.callback = callback;
        this.updateRequirementsScrollArea();
    }

    protected void method_25426() {
        this.addRequirementButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.add_requirement", (Object[])new Object[0]), button -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addInstance((LoadingRequirementInstance)call);
                    this.updateRequirementsScrollArea();
                }
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.method_25429((class_364)this.addRequirementButton);
        this.addRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.manage_screen.add_requirement.desc", new String[0])).setDefaultStyle());
        UIBase.applyDefaultWidgetSkinTo(this.addRequirementButton);
        this.addGroupButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.add_group", (Object[])new Object[0]), button -> {
            BuildRequirementGroupScreen s = new BuildRequirementGroupScreen(this, this.container, null, call -> {
                if (call != null) {
                    this.container.addGroup((LoadingRequirementGroup)call);
                    this.updateRequirementsScrollArea();
                }
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.method_25429((class_364)this.addGroupButton);
        this.addGroupButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.manage_screen.add_group.desc", new String[0])).setDefaultStyle());
        UIBase.applyDefaultWidgetSkinTo(this.addGroupButton);
        this.editButton = new ExtendedButton(0, 0, 150, 20, "", button -> {
            ModernScreen s = null;
            if (this.isInstanceSelected()) {
                s = new BuildRequirementScreen(this, this.container, this.getSelectedInstance(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            } else if (this.isGroupSelected()) {
                s = new BuildRequirementGroupScreen(this, this.container, this.getSelectedGroup(), call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            }
            if (s != null) {
                class_310.method_1551().method_1507(s);
            }
        }){

            @Override
            public void method_25394(@NotNull class_4587 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setLabel(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.manage_screen.edit.generic", (Object[])new Object[0]));
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", new String[0])).setDefaultStyle());
                    this.field_22763 = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setLabel(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.edit_requirement", (Object[])new Object[0]));
                    } else {
                        this.setLabel(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.edit_group", (Object[])new Object[0]));
                    }
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.manage_screen.edit.desc", new String[0])).setDefaultStyle());
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429((class_364)this.editButton);
        UIBase.applyDefaultWidgetSkinTo(this.editButton);
        this.removeButton = new ExtendedButton(0, 0, 150, 20, "", button -> {
            ConfirmationScreen s = null;
            if (this.isInstanceSelected()) {
                LoadingRequirementInstance i = this.getSelectedInstance();
                s = ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        this.container.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.remove_requirement.confirm", new String[0]));
            } else if (this.isGroupSelected()) {
                LoadingRequirementGroup g = this.getSelectedGroup();
                s = ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        this.container.removeGroup(g);
                        this.updateRequirementsScrollArea();
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.remove_group.confirm", new String[0]));
            }
            if (s != null) {
                class_310.method_1551().method_1507(s);
            }
        }){

            @Override
            public void method_25394(@NotNull class_4587 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setLabel(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.manage_screen.remove.generic", (Object[])new Object[0]));
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.manage_screen.no_entry_selected", new String[0])).setDefaultStyle());
                    this.field_22763 = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setLabel(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.remove_requirement", (Object[])new Object[0]));
                    } else {
                        this.setLabel(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.remove_group", (Object[])new Object[0]));
                    }
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.manage_screen.remove.desc", new String[0])).setDefaultStyle());
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429((class_364)this.removeButton);
        UIBase.applyDefaultWidgetSkinTo(this.removeButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.guicomponents.cancel", (Object[])new Object[0]), button -> this.callback.accept(null));
        this.method_25429((class_364)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.guicomponents.done", (Object[])new Object[0]), button -> this.callback.accept(this.container));
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.drawString(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.field_22793, class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.manage_screen.requirements_and_groups", (Object[])new Object[0]), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementsScrollArea.setWidth(this.field_22789 - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.field_22790 - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(65, true);
        this.requirementsScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.field_22760 = this.field_22789 - 20 - this.doneButton.method_25368();
        this.doneButton.field_22761 = this.field_22790 - 20 - 20;
        this.doneButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.cancelButton.field_22760 = this.field_22789 - 20 - this.cancelButton.method_25368();
        this.cancelButton.field_22761 = this.doneButton.field_22761 - 5 - 20;
        this.cancelButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.removeButton.field_22760 = this.field_22789 - 20 - this.removeButton.method_25368();
        this.removeButton.field_22761 = this.cancelButton.field_22761 - 15 - 20;
        this.removeButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.editButton.field_22760 = this.field_22789 - 20 - this.editButton.method_25368();
        this.editButton.field_22761 = this.removeButton.field_22761 - 5 - 20;
        this.editButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.addGroupButton.field_22760 = this.field_22789 - 20 - this.addGroupButton.method_25368();
        this.addGroupButton.field_22761 = this.editButton.field_22761 - 5 - 20;
        this.addGroupButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.addRequirementButton.field_22760 = this.field_22789 - 20 - this.addRequirementButton.method_25368();
        this.addRequirementButton.field_22761 = this.addGroupButton.field_22761 - 5 - 20;
        this.addRequirementButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Nullable
    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementInstanceEntry) {
            return ((RequirementInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    @Nullable
    protected LoadingRequirementGroup getSelectedGroup() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementGroupEntry) {
            return ((RequirementGroupEntry)e).group;
        }
        return null;
    }

    protected boolean isGroupSelected() {
        return this.getSelectedGroup() != null;
    }

    protected void updateRequirementsScrollArea() {
        ScrollAreaEntry e;
        this.requirementsScrollArea.clearEntries();
        for (LoadingRequirementGroup g : this.container.getGroups()) {
            e = new RequirementGroupEntry(this.requirementsScrollArea, g);
            this.requirementsScrollArea.addEntry(e);
        }
        for (LoadingRequirementInstance i : this.container.getInstances()) {
            e = new RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }
    }

    public static class RequirementInstanceEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementInstance instance;
        public final int lineHeight;
        public class_327 font;
        private final class_5250 displayNameComponent;
        private final class_5250 modeComponent;
        private final class_5250 valueComponent;

        public RequirementInstanceEntry(ScrollArea parent, LoadingRequirementInstance instance, int lineHeight) {
            super(parent, 100, 30);
            this.font = class_310.method_1551().field_1772;
            this.instance = instance;
            this.lineHeight = lineHeight;
            this.displayNameComponent = Components.literal(this.instance.requirement.getDisplayName()).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            String modeString = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.normal", (Object[])new Object[0]) : class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode.opposite", (Object[])new Object[0]);
            this.modeComponent = Components.literal(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.requirement.info.mode", (Object[])new Object[0]) + " ").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852((class_2561)Components.literal(modeString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())));
            String valueString = this.instance.value != null ? this.instance.value : class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value.none", (Object[])new Object[0]);
            this.valueComponent = Components.literal(class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.requirement.info.value", (Object[])new Object[0]) + " ").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852((class_2561)Components.literal(valueString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())));
            this.setWidth(this.calculateWidth());
            this.setHeight(lineHeight * 3 + 6);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            int centerYLine3 = this.getY() + 3 + this.lineHeight / 2 * 5;
            RenderSystem.enableBlend();
            RequirementInstanceEntry.renderListingDot(graphics, this.getX() + 5, centerYLine1 - 2, UIBase.getUIColorTheme().listing_dot_color_2.getColor());
            int n = this.getX() + 5 + 4 + 3;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (class_2561)this.displayNameComponent, n, centerYLine1 - 9 / 2, -1, false);
            RequirementInstanceEntry.renderListingDot(graphics, this.getX() + 5 + 4 + 3, centerYLine2 - 2, UIBase.getUIColorTheme().listing_dot_color_1.getColor());
            int n2 = this.getX() + 5 + 4 + 3 + 4 + 3;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (class_2561)this.modeComponent, n2, centerYLine2 - 9 / 2, -1, false);
            RequirementInstanceEntry.renderListingDot(graphics, this.getX() + 5 + 4 + 3, centerYLine3 - 2, UIBase.getUIColorTheme().listing_dot_color_1.getColor());
            int n3 = this.getX() + 5 + 4 + 3 + 4 + 3;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (class_2561)this.valueComponent, n3, centerYLine3 - 9 / 2, -1, false);
        }

        private int calculateWidth() {
            int w = 12 + this.font.method_27525((class_5348)this.displayNameComponent) + 5;
            int w2 = 19 + this.font.method_27525((class_5348)this.modeComponent) + 5;
            int w3 = 19 + this.font.method_27525((class_5348)this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            if (w3 > w) {
                w = w3;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
        }
    }

    public static class RequirementGroupEntry
    extends TextListScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public LoadingRequirementGroup group;

        public RequirementGroupEntry(ScrollArea parent, LoadingRequirementGroup group) {
            super(parent, (class_2561)Components.literal(group.identifier).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852((class_2561)Components.literal(" (" + class_1074.method_4662((String)"fancymenu.editor.loading_requirement.screens.manage_screen.group.info", (Object[])new Object[]{"" + group.getInstances().size()}) + ")").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))), UIBase.getUIColorTheme().listing_dot_color_3.getColor(), entry -> {});
            this.group = group;
            this.setHeight(this.getHeight() + 6);
        }
    }
}

