/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChoosePanoramaScreen
extends ModernScreen {
    protected Consumer<String> callback;
    protected String selectedPanoramaName = null;
    protected ScrollArea panoramaListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChoosePanoramaScreen(@Nullable String preSelectedPanorama, @NotNull Consumer<String> callback) {
        super((class_2561)Components.translatable("fancymenu.panorama.choose", new Object[0]));
        this.callback = callback;
        this.updatePanoramaScrollAreaContent();
        if (preSelectedPanorama != null) {
            for (ScrollAreaEntry e : this.panoramaListScrollArea.getEntries()) {
                if (!(e instanceof PanoramaScrollEntry)) continue;
                PanoramaScrollEntry a = (PanoramaScrollEntry)e;
                if (!a.panorama.equals(preSelectedPanorama)) continue;
                a.setSelected(true);
                this.setSelectedPanorama(a);
                break;
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (class_2561)Components.translatable("fancymenu.guicomponents.done", new Object[0]), button -> this.callback.accept(this.selectedPanoramaName)){

            @Override
            public void method_25359(@NotNull class_4587 graphics, int mouseX, int mouseY, float partial) {
                if (ChoosePanoramaScreen.this.selectedPanoramaName == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((class_339)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.panorama.choose.no_panorama_selected", new String[0])).setDefaultStyle(), false, true);
                    this.field_22763 = false;
                } else {
                    this.field_22763 = true;
                }
                super.method_25359(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (class_2561)Components.translatable("fancymenu.guicomponents.cancel", new Object[0]), button -> this.callback.accept(null));
        this.method_25429((class_364)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.drawString(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.field_22793, (class_2561)Components.translatable("fancymenu.panorama.choose.available_panoramas", new Object[0]), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.panoramaListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.panoramaListScrollArea.setHeight(this.field_22790 - 85, true);
        this.panoramaListScrollArea.setX(20, true);
        this.panoramaListScrollArea.setY(65, true);
        this.panoramaListScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.field_22760 = this.field_22789 - 20 - this.doneButton.method_25368();
        this.doneButton.field_22761 = this.field_22790 - 20 - 20;
        this.doneButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        this.cancelButton.field_22760 = this.field_22789 - 20 - this.cancelButton.method_25368();
        this.cancelButton.field_22761 = this.doneButton.field_22761 - 5 - 20;
        this.cancelButton.method_25394(graphics.pose(), mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    protected void setSelectedPanorama(@Nullable PanoramaScrollEntry entry) {
        if (entry == null) {
            this.selectedPanoramaName = null;
            return;
        }
        this.selectedPanoramaName = entry.panorama;
    }

    protected void updatePanoramaScrollAreaContent() {
        this.panoramaListScrollArea.clearEntries();
        for (String s : PanoramaHandler.getPanoramaNames()) {
            ScrollAreaEntry e = new PanoramaScrollEntry(this.panoramaListScrollArea, s, entry -> this.setSelectedPanorama((PanoramaScrollEntry)entry));
            this.panoramaListScrollArea.addEntry(e);
        }
        if (this.panoramaListScrollArea.getEntries().isEmpty()) {
            this.panoramaListScrollArea.addEntry(new TextScrollAreaEntry(this.panoramaListScrollArea, (class_2561)Components.translatable("fancymenu.panorama.choose.no_panoramas", new Object[0]), entry -> {}));
        }
        int totalWidth = this.panoramaListScrollArea.getTotalEntryWidth();
        for (ScrollAreaEntry e : this.panoramaListScrollArea.getEntries()) {
            e.setWidth(totalWidth);
        }
    }

    public boolean method_25404(int button, int $$1, int $$2) {
        if (button == 257 && this.selectedPanoramaName != null) {
            this.callback.accept(this.selectedPanoramaName);
            return true;
        }
        return super.method_25404(button, $$1, $$2);
    }

    public static class PanoramaScrollEntry
    extends TextListScrollAreaEntry {
        public String panorama;

        public PanoramaScrollEntry(ScrollArea parent, @NotNull String panorama, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (class_2561)Components.literal(panorama).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.panorama = panorama;
        }
    }
}

