/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.splash;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.splash.SplashTextElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class SplashTextEditorElement
extends AbstractEditorElement {
    public SplashTextEditorElement(@NotNull AbstractElement element, @NotNull LayoutEditorScreen editor) {
        super(element, editor);
    }

    @Override
    public void init() {
        super.init();
        this.addGenericCycleContextMenuEntryTo(this.rightClickMenu, "set_mode", ListUtils.of(SplashTextElement.SourceMode.VANILLA, SplashTextElement.SourceMode.DIRECT_TEXT, SplashTextElement.SourceMode.TEXT_FILE), consumes -> consumes instanceof SplashTextEditorElement, consumes -> ((SplashTextElement)consumes.element).sourceMode, (element1, sourceMode) -> {
            ((SplashTextElement)element1.element).sourceMode = sourceMode;
            ((SplashTextElement)element1.element).source = null;
        }, (menu, entry, switcherValue) -> {
            if (switcherValue == SplashTextElement.SourceMode.VANILLA) {
                return Components.translatable("fancymenu.elements.splash.source_mode.vanilla", new Object[0]);
            }
            if (switcherValue == SplashTextElement.SourceMode.DIRECT_TEXT) {
                return Components.translatable("fancymenu.elements.splash.source_mode.direct", new Object[0]);
            }
            return Components.translatable("fancymenu.elements.splash.source_mode.text_file", new Object[0]);
        });
        ((ContextMenu.ClickableContextMenuEntry)this.addTextResourceChooserContextMenuEntryTo(this.rightClickMenu, "set_source_file", SplashTextEditorElement.class, null, consumes -> consumes.getElement().textFileSupplier, (splashTextEditorElement, iTextResourceSupplier) -> {
            splashTextEditorElement.getElement().textFileSupplier = iTextResourceSupplier;
            if (iTextResourceSupplier != null) {
                splashTextEditorElement.getElement().source = iTextResourceSupplier.getSourceWithPrefix();
            }
            splashTextEditorElement.getElement().refresh();
            splashTextEditorElement.getElement().updateSplash();
        }, (class_2561)Components.translatable("fancymenu.elements.splash.source_mode.text_file.set_source", new Object[0]), false, null, true, true, true).setIsVisibleSupplier((menu, entry) -> ((SplashTextElement)this.element).sourceMode == SplashTextElement.SourceMode.TEXT_FILE)).setIcon(ContextMenu.IconFactory.getIcon("text"));
        ((ContextMenu.ClickableContextMenuEntry)this.addGenericStringInputContextMenuEntryTo(this.rightClickMenu, "input_direct", consumes -> consumes instanceof SplashTextEditorElement, consumes -> ((SplashTextElement)consumes.element).source, (element1, s) -> {
            ((SplashTextElement)element1.element).source = s;
            ((SplashTextElement)element1.element).updateSplash();
        }, null, false, true, (class_2561)Components.translatable("fancymenu.elements.splash.source_mode.direct.set_source", new Object[0]), false, null, TextValidators.NO_EMPTY_STRING_TEXT_VALIDATOR, null).setIsVisibleSupplier((menu, entry) -> ((SplashTextElement)this.element).sourceMode == SplashTextElement.SourceMode.DIRECT_TEXT)).setIcon(ContextMenu.IconFactory.getIcon("text"));
        this.rightClickMenu.addSeparatorEntry("splash_separator_1");
        ((ContextMenu.ClickableContextMenuEntry)this.addGenericFloatInputContextMenuEntryTo(this.rightClickMenu, "set_scale", consumes -> consumes instanceof SplashTextEditorElement, consumes -> Float.valueOf(((SplashTextElement)consumes.element).scale), (element, scale) -> {
            ((SplashTextElement)element.element).scale = Math.max(0.2f, scale.floatValue());
            ((SplashTextElement)element.element).updateSplash();
        }, (class_2561)Components.translatable("fancymenu.elements.splash.set_scale", new Object[0]), true, 1.0f, null, null).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        this.addGenericFloatInputContextMenuEntryTo(this.rightClickMenu, "set_rotation", consumes -> consumes instanceof SplashTextEditorElement, consumes -> Float.valueOf(((SplashTextElement)consumes.element).rotation), (element, rot) -> {
            ((SplashTextElement)element.element).rotation = rot.floatValue();
            ((SplashTextElement)element.element).updateSplash();
        }, (class_2561)Components.translatable("fancymenu.editor.items.splash.rotation", new Object[0]), true, 20.0f, null, null).setStackable(true);
        this.addGenericStringInputContextMenuEntryTo(this.rightClickMenu, "set_color", consumes -> consumes instanceof SplashTextEditorElement, consumes -> ((SplashTextElement)consumes.element).baseColor.getHex(), (element1, s) -> {
            ((SplashTextElement)element1.element).baseColor = DrawableColor.of(s);
            ((SplashTextElement)element1.element).updateSplash();
        }, null, false, true, (class_2561)Components.translatable("fancymenu.editor.items.splash.basecolor", new Object[0]), true, DrawableColor.of(255, 255, 0).getHex(), TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        ((ContextMenu.ClickableContextMenuEntry)this.addGenericBooleanSwitcherContextMenuEntryTo(this.rightClickMenu, "shadow", consumes -> consumes instanceof SplashTextEditorElement, consumes -> ((SplashTextElement)consumes.element).shadow, (element1, s) -> {
            ((SplashTextElement)element1.element).shadow = s;
        }, "fancymenu.elements.splash.shadow").setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("shadow"));
        this.addGenericBooleanSwitcherContextMenuEntryTo(this.rightClickMenu, "bouncing", consumes -> consumes instanceof SplashTextEditorElement, consumes -> ((SplashTextElement)consumes.element).bounce, (element1, s) -> {
            ((SplashTextElement)element1.element).bounce = s;
        }, "fancymenu.editor.items.splash.bounce").setStackable(true);
        ((ContextMenu.ClickableContextMenuEntry)this.addGenericBooleanSwitcherContextMenuEntryTo(this.rightClickMenu, "refresh_on_load", consumes -> consumes instanceof SplashTextEditorElement, consumes -> ((SplashTextElement)consumes.element).refreshOnMenuReload, (element1, s) -> {
            ((SplashTextElement)element1.element).refreshOnMenuReload = s;
        }, "fancymenu.editor.items.splash.refresh").setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.items.splash.refresh.desc", new String[0])));
    }

    public SplashTextElement getElement() {
        return (SplashTextElement)this.element;
    }
}

