/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.dragger;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.dragger.DraggerEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.dragger.DraggerElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import java.awt.Color;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DraggerElementBuilder
extends ElementBuilder<DraggerElement, DraggerEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DraggerElementBuilder() {
        super("dragger");
    }

    @Override
    @NotNull
    public DraggerElement buildDefaultInstance() {
        DraggerElement i = new DraggerElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        i.inEditorColor = DrawableColor.of(new Color(227, 14, 35));
        return i;
    }

    @Override
    public DraggerElement deserializeElement(@NotNull SerializedElement serialized) {
        DraggerElement element = this.buildDefaultInstance();
        element.saveDragOffset = this.deserializeBoolean(element.saveDragOffset, serialized.getValue("save_drag_offset"));
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull DraggerElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("save_drag_offset", "" + element.saveDragOffset);
        return serializeTo;
    }

    @Override
    @NotNull
    public DraggerEditorElement wrapIntoEditorElement(@NotNull DraggerElement element, @NotNull LayoutEditorScreen editor) {
        return new DraggerEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return Components.translatable("fancymenu.elements.dragger", new Object[0]);
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.dragger.desc", new String[0]);
    }
}

