/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.ElementSelectorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class TargetElementManagerScreen
extends CellScreen {
    protected final AnimationControllerElement element;
    protected final LayoutEditorScreen parentLayoutEditor;
    protected final Consumer<List<AnimationControllerElement.TargetElement>> callback;
    protected final List<AnimationControllerElement.TargetElement> targets;

    public TargetElementManagerScreen(@NotNull AnimationControllerEditorElement editorElement, @NotNull Consumer<List<AnimationControllerElement.TargetElement>> callback) {
        super((class_2561)Components.translatable("fancymenu.elements.animation_controller.manage_targets", new Object[0]));
        this.element = editorElement.getElement();
        this.parentLayoutEditor = editorElement.editor;
        this.callback = callback;
        this.targets = new ArrayList<AnimationControllerElement.TargetElement>(this.element.targetElements);
    }

    @Override
    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addLabelCell((class_2561)Components.translatable("fancymenu.elements.animation_controller.manage_targets.info", new Object[0]).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        this.addCellGroupEndSpacerCell();
        this.addCellGroupEndSpacerCell();
        if (this.targets.isEmpty()) {
            this.addLabelCell((class_2561)Components.translatable("fancymenu.elements.animation_controller.manage_targets.no_targets", new Object[0]).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())));
        } else {
            for (AnimationControllerElement.TargetElement target : this.targets) {
                AbstractEditorElement e = this.parentLayoutEditor.getElementByInstanceIdentifier(target.targetElementId);
                class_2585 label = e != null ? e.element.getDisplayName().method_27661() : Components.literal("---");
                label = label.method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
                label = label.method_10852((class_2561)Components.literal(" [" + target.targetElementId + "]").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().generic_text_base_color.getColorInt())));
                this.addLabelCell((class_2561)label);
            }
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (class_2561)Components.translatable("fancymenu.elements.animation_controller.manage_targets.add", new Object[0]), button -> {
            ElementSelectorScreen selector = new ElementSelectorScreen(this.parentLayoutEditor, this, this.getElementIds(), selectedElement -> {
                if (selectedElement != null) {
                    String elementId = selectedElement.element.getInstanceIdentifier();
                    if (this.targets.stream().anyMatch(t -> t.targetElementId.equals(elementId))) {
                        class_310.method_1551().method_1507((class_437)ConfirmationScreen.warning(result -> class_310.method_1551().method_1507((class_437)this), LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.manage_targets.already_exists", new String[0])));
                    } else {
                        this.targets.add(new AnimationControllerElement.TargetElement(elementId));
                        class_310.method_1551().method_1507((class_437)this);
                    }
                } else {
                    class_310.method_1551().method_1507((class_437)this);
                }
            });
            class_310.method_1551().method_1507((class_437)selector);
        });
        this.addRightSideButton(20, (class_2561)Components.translatable("fancymenu.elements.animation_controller.manage_targets.remove", new Object[0]), button -> {
            ElementSelectorScreen selector = new ElementSelectorScreen(this.parentLayoutEditor, this, this.getElementIds(), selectedElement -> {
                if (selectedElement != null) {
                    String elementId = selectedElement.element.getInstanceIdentifier();
                    this.targets.removeIf(t -> t.targetElementId.equals(elementId));
                }
                class_310.method_1551().method_1507((class_437)this);
            }, element -> this.targets.stream().anyMatch(t -> t.targetElementId.equals(element.element.getInstanceIdentifier())));
            class_310.method_1551().method_1507((class_437)selector);
        });
        this.addRightSideDefaultSpacer();
    }

    protected List<String> getElementIds() {
        ArrayList<String> ids = new ArrayList<String>();
        this.targets.forEach(targetElement -> ids.add(targetElement.targetElementId));
        return ids;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.targets);
    }
}

