/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.audio;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TogglePlayTrackAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public TogglePlayTrackAction() {
        super("audio_toggle_play");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            AbstractElement element;
            ScreenCustomizationLayer layer;
            if (value != null && (layer = ScreenCustomizationLayerHandler.getActiveLayer()) != null && (element = layer.getElementByInstanceIdentifier(value)) instanceof AudioElement) {
                AudioElement audio = (AudioElement)element;
                if (audio.currentAudio != null) {
                    if (audio.currentAudio.isPlaying()) {
                        audio.currentAudio.pause();
                    } else if (audio.currentAudio.isPaused()) {
                        audio.currentAudio.play();
                    } else {
                        audio.currentAudio.play();
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute TogglePlayAudioAction!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return Components.translatable("fancymenu.actions.audio.toggle_play", new Object[0]);
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.audio.toggle_play.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return Components.translatable("fancymenu.actions.audio.toggle_play.value.desc", new Object[0]);
    }

    @Override
    public String getValueExample() {
        return "audio_element_identifier";
    }
}

