/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.layout.command.LayoutCommandPacket;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.konkrete.command.CommandUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class LayoutCommand {
    public static final Map<String, List<String>> CACHED_LAYOUT_SUGGESTIONS = Collections.synchronizedMap(new HashMap());

    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)class_2170.method_9247((String)"fmlayout").then(class_2170.method_9244((String)"layout_name", (ArgumentType)StringArgumentType.string()).suggests((context, provider) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)provider, (String[])LayoutCommand.getLayoutNameSuggestions(((class_2168)context.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"is_layout_enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> LayoutCommand.setLayoutState((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"layout_name"), BoolArgumentType.getBool((CommandContext)context, (String)"is_layout_enabled"), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target_players", (ArgumentType)class_2186.method_9308()).requires(context -> context.method_9259(2))).executes(context -> LayoutCommand.setLayoutState((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"layout_name"), BoolArgumentType.getBool((CommandContext)context, (String)"is_layout_enabled"), class_2186.method_9312((CommandContext)context, (String)"target_players")))))));
    }

    private static String[] getLayoutNameSuggestions(class_3222 sender) {
        ArrayList<String> l = new ArrayList<String>(Objects.requireNonNullElse(CACHED_LAYOUT_SUGGESTIONS.get(sender.method_5667().toString()), new ArrayList()));
        if (l.isEmpty()) {
            l.add("<no_layouts_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int setLayoutState(class_2168 stack, String layoutName, boolean enabled, @Nullable Collection<class_3222> targets) {
        try {
            if (targets == null) {
                class_3222 sender = stack.method_9207();
                LayoutCommandPacket packet = new LayoutCommandPacket();
                packet.layout_name = layoutName;
                packet.enabled = enabled;
                PacketHandler.sendToClient(sender, packet);
            } else {
                for (class_3222 target : targets) {
                    LayoutCommandPacket packet = new LayoutCommandPacket();
                    packet.layout_name = layoutName;
                    packet.enabled = enabled;
                    PacketHandler.sendToClient(target, packet);
                }
            }
        }
        catch (Exception ex) {
            stack.method_9213((class_2561)Components.literal("Error while executing /fmlayout command!"));
            ex.printStackTrace();
        }
        return 1;
    }
}

