/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.network;

import com.kneelawk.graphlib.GraphLib;
import com.kneelawk.graphlib.graph.BlockGraph;
import com.kneelawk.graphlib.graph.BlockGraphController;
import com.kneelawk.graphlib.graph.BlockNode;
import com.kneelawk.graphlib.graph.BlockNodeHolder;
import com.kneelawk.graphlib.graph.struct.Node;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.network.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.network.node.AbstractDrawerBlockNode;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import org.apache.commons.lang3.ObjectUtils;

public class UpdateHandler {
    private static final Map<class_5321<class_1937>, Long2ObjectMap<ChangeType>> UPDATES = new HashMap<class_5321<class_1937>, Long2ObjectMap<ChangeType>>();
    private static final Map<class_5321<class_1937>, List<class_2338>> REFRESHES = new HashMap<class_5321<class_1937>, List<class_2338>>();

    public static void scheduleRefresh(class_3218 world, class_2338 pos) {
        REFRESHES.computeIfAbsent((class_5321<class_1937>)world.method_27983(), key -> new ArrayList()).add(pos);
    }

    public static void scheduleUpdate(class_3218 world, class_2338 pos, ChangeType type) {
        GraphLib.getController((class_3218)world).getGraphsAt(pos).forEach(graph -> UpdateHandler.scheduleUpdate(world, graph, type));
    }

    public static void scheduleUpdate(class_3218 world, long id, ChangeType type) {
        Long2ObjectMap map = UPDATES.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new Long2ObjectOpenHashMap());
        map.compute(id, (__, old) -> (ChangeType)((Object)((Object)ObjectUtils.max((Comparable[])new ChangeType[]{old, type}))));
    }

    public static void flushUpdates(class_3218 world) {
        BlockGraphController controller = GraphLib.getController((class_3218)world);
        class_3695 profiler = world.method_16107();
        profiler.method_15396("extended_drawers:network_updates");
        Long2ObjectMap<ChangeType> updates = UPDATES.remove(world.method_27983());
        if (updates != null) {
            updates.forEach((id, type) -> {
                BlockGraph graph = controller.getGraph(id.longValue());
                if (graph == null) {
                    return;
                }
                NetworkStorageCache.update(world, id, type);
                UpdateHandler.updateGraph(world, graph.getNodes(), type);
            });
        }
        profiler.method_15407();
        profiler.method_15396("extended_drawers:node_updates");
        List<class_2338> refreshes = REFRESHES.remove(world.method_27983());
        if (refreshes != null) {
            for (class_2338 pos : refreshes) {
                ExtendedDrawers.LOGGER.debug("Refreshing graph at " + pos);
                controller.updateNodes(pos);
            }
        }
        profiler.method_15407();
    }

    public static void clear() {
        UPDATES.clear();
        REFRESHES.clear();
    }

    private static void updateGraph(class_3218 world, Stream<Node<BlockNodeHolder>> nodes, ChangeType type) {
        nodes.forEach(node -> {
            BlockNode patt2963$temp = ((BlockNodeHolder)node.data()).getNode();
            if (patt2963$temp instanceof AbstractDrawerBlockNode) {
                AbstractDrawerBlockNode drawerNode = (AbstractDrawerBlockNode)patt2963$temp;
                drawerNode.update(world, (Node<BlockNodeHolder>)node, type);
            }
        });
    }

    public static enum ChangeType {
        COUNT,
        CONTENT,
        STRUCTURE;

    }
}

