/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.drawer;

import io.github.mattidragon.extendeddrawers.config.CommonConfig;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrawerSlot
extends SnapshotParticipant<Snapshot>
implements SingleSlotStorage<ItemVariant>,
Comparable<DrawerSlot> {
    private final BooleanConsumer onChange;
    private boolean sortingChanged;
    private final double capacityMultiplier;
    private ItemVariant item = ItemVariant.blank();
    private long amount;
    @Nullable
    private UpgradeItem upgrade = null;
    private boolean locked;
    private boolean voiding;
    private boolean hidden;

    public DrawerSlot(BooleanConsumer onChange, double capacityMultiplier) {
        this.onChange = onChange;
        this.capacityMultiplier = capacityMultiplier;
    }

    public boolean changeUpgrade(@Nullable UpgradeItem newUpgrade, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        UpgradeItem oldUpgrade = this.upgrade;
        this.upgrade = newUpgrade;
        if (this.getCapacity() < this.getAmount() && ((CommonConfig)CommonConfig.HANDLE.get()).blockUpgradeRemovalsWithOverflow()) {
            this.upgrade = oldUpgrade;
            if (player != null) {
                player.method_7353((class_2561)new class_2588("extended_drawer.drawer.upgrade_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, new class_1799((class_1935)oldUpgrade));
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!resource.equals(this.item) && !this.item.isBlank() || !resource.getItem().method_31568()) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        long inserted = Math.min(this.getCapacity() - this.amount, maxAmount);
        this.amount += inserted;
        if (this.item.isBlank()) {
            this.item = resource;
            this.sortingChanged = true;
        }
        return this.voiding ? maxAmount : inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!resource.equals(this.item)) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        long extracted = Math.min(this.amount, maxAmount);
        this.amount -= extracted;
        if (this.amount == 0L && !this.locked) {
            this.item = ItemVariant.blank();
            this.sortingChanged = true;
        }
        return extracted;
    }

    public boolean isResourceBlank() {
        return this.item.isBlank();
    }

    public ItemVariant getResource() {
        return this.item;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        CommonConfig config = (CommonConfig)CommonConfig.HANDLE.get();
        long capacity = (long)((double)config.defaultCapacity() * this.capacityMultiplier);
        if (config.stackSizeAffectsCapacity()) {
            capacity = (long)((double)capacity / (64.0 / (double)this.item.getItem().method_7882()));
        }
        if (this.upgrade != null) {
            capacity = this.upgrade.modifier.applyAsLong(capacity);
        }
        return capacity;
    }

    protected Snapshot createSnapshot() {
        return new Snapshot((ResourceAmount<ItemVariant>)new ResourceAmount((Object)this.item, this.amount), this.sortingChanged);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.item = (ItemVariant)snapshot.contents.resource();
        this.amount = snapshot.contents.amount();
        this.sortingChanged = snapshot.itemChanged;
    }

    protected void onFinalCommit() {
        this.update();
    }

    public void update() {
        this.onChange.accept(this.sortingChanged);
        this.sortingChanged = false;
    }

    public void dumpExcess(class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        if (this.amount > this.getCapacity()) {
            ItemUtils.offerOrDropStacks(world, pos, side, player, this.item, this.amount - this.getCapacity());
            this.amount = this.getCapacity();
        }
        this.update();
    }

    @Override
    public int compareTo(@NotNull DrawerSlot other) {
        if (this.isResourceBlank() != other.isResourceBlank()) {
            return this.isResourceBlank() ? 1 : -1;
        }
        if (this.locked != other.locked) {
            return this.locked ? -1 : 1;
        }
        if (this.voiding != other.voiding) {
            return this.voiding ? 1 : -1;
        }
        return 0;
    }

    public void readNbt(class_2487 nbt) {
        UpgradeItem upgrade;
        this.item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        this.amount = nbt.method_10537("amount");
        this.locked = nbt.method_10577("locked");
        this.voiding = nbt.method_10577("voiding");
        this.hidden = nbt.method_10577("hidden");
        Object object = class_2378.field_11142.method_10223(class_2960.method_12829((String)nbt.method_10558("upgrade")));
        this.upgrade = object instanceof UpgradeItem ? (upgrade = (UpgradeItem)((Object)object)) : null;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10566("item", (class_2520)this.item.toNbt());
        nbt.method_10544("amount", this.amount);
        nbt.method_10556("locked", this.locked);
        nbt.method_10556("voiding", this.voiding);
        nbt.method_10556("hidden", this.hidden);
        nbt.method_10582("upgrade", class_2378.field_11142.method_10221((Object)this.upgrade).toString());
    }

    public ItemVariant getItem() {
        return this.item;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isVoiding() {
        return this.voiding;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Nullable
    public UpgradeItem getUpgrade() {
        return this.upgrade;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.update();
    }

    public void setVoiding(boolean voiding) {
        this.voiding = voiding;
        this.sortingChanged = true;
        this.update();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.sortingChanged = true;
        if (!locked && this.amount == 0L) {
            this.item = ItemVariant.blank();
        }
        this.update();
    }

    record Snapshot(ResourceAmount<ItemVariant> contents, boolean itemChanged) {
    }
}

