/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.config.ClientConfig;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDrawerBlockEntityRenderer<T extends class_2586>
implements class_827<T> {
    public AbstractDrawerBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void renderSlot(ItemVariant item, @Nullable Long amount, List<class_1058> icons, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, int seed, class_2338 pos) {
        ClientConfig config;
        class_243 playerPos = class_310.method_1551().field_1724.method_19538();
        if (pos.method_19769((class_2374)playerPos, (double)(config = (ClientConfig)ClientConfig.HANDLE.get()).textRenderDistance()) && amount != null) {
            this.renderText(amount, light, matrices, vertexConsumers);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.iconRenderDistance())) {
            this.renderIcons(icons, light, matrices, vertexConsumers, overlay);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.itemRenderDistance())) {
            this.renderItem(item, light, matrices, vertexConsumers, seed);
        }
    }

    protected final boolean shouldRender(T drawer, class_2350 facing) {
        class_1937 world = drawer.method_10997();
        if (world == null) {
            return false;
        }
        class_2338 pos = drawer.method_11016();
        class_2680 state = drawer.method_11010();
        return class_2248.method_9607((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)facing, (class_2338)pos.method_10093(facing));
    }

    private void renderIcons(List<class_1058> icons, int light, class_4587 matrices, class_4597 vertexConsumers, int overlay) {
        double increment = 1.0 / ((double)icons.size() + 1.0);
        matrices.method_22903();
        matrices.method_22904(-0.5, 0.0, 0.0);
        for (class_1058 icon : icons) {
            matrices.method_22904(increment, 0.0, 0.0);
            this.renderIcon(icon, light, matrices, vertexConsumers, overlay);
        }
        matrices.method_22909();
    }

    private void renderIcon(class_1058 sprite, int light, class_4587 matrices, class_4597 vertexConsumers, int overlay) {
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
        matrices.method_22904(-0.125, -0.24, -0.5);
        matrices.method_22905(0.25f, 0.25f, 0.25f);
        QuadEmitter emitter = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer()).meshBuilder().getEmitter();
        emitter.square(class_2350.field_11036, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        emitter.spriteBake(0, sprite, 4);
        vertexConsumers.getBuffer(class_1921.method_23581()).method_22919(matrices.method_23760(), emitter.toBakedQuad(0, sprite, false), 1.0f, 1.0f, 1.0f, light, overlay);
        matrices.method_22909();
    }

    private void renderItem(ItemVariant item, int light, class_4587 matrices, class_4597 vertexConsumers, int seed) {
        matrices.method_22903();
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        matrices.method_34425(class_1159.method_24019((float)1.0f, (float)1.0f, (float)0.01f));
        class_310.method_1551().method_1480().method_23178(item.toStack(), class_809.class_811.field_4317, light, class_4608.field_21444, matrices, vertexConsumers, seed);
        matrices.method_22909();
    }

    private void renderText(long amount, int light, class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20703.method_23214(180.0f));
        matrices.method_22904(0.0, 0.3, -0.01);
        matrices.method_22905(0.02f, 0.02f, 0.02f);
        class_327 textRenderer = class_310.method_1551().field_1772;
        String text = Long.toString(amount);
        textRenderer.method_27521(text, (float)(-textRenderer.method_1727(text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
        matrices.method_22909();
    }
}

