/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block.entity;

import io.github.mattidragon.extendeddrawers.drawer.DrawerSlot;
import io.github.mattidragon.extendeddrawers.network.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ShadowDrawerBlockEntity
extends class_2586 {
    public ItemVariant item = ItemVariant.blank();
    public long countCache = -1L;
    private boolean hidden = false;

    public ShadowDrawerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.SHADOW_DRAWER_BLOCK_ENTITY, pos, state);
    }

    private static Storage<ItemVariant> createStorage(class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof ShadowDrawerBlockEntity)) {
            throw new IllegalStateException();
        }
        ShadowDrawerBlockEntity shadowDrawer = (ShadowDrawerBlockEntity)class_25862;
        ShadowDrawerBlockEntity shadowDrawerBlockEntity = shadowDrawer;
        Objects.requireNonNull(shadowDrawerBlockEntity);
        return shadowDrawerBlockEntity.new ShadowDrawerStorage((Storage<ItemVariant>)NetworkStorageCache.get(world, pos));
    }

    public void recalculateContents() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (!this.item.isBlank()) {
                CombinedStorage<ItemVariant, DrawerSlot> storage = NetworkStorageCache.get(world, this.field_11867);
                long amount = 0L;
                for (DrawerSlot slot : storage.parts) {
                    if (!slot.getResource().equals(this.item)) continue;
                    amount += slot.getAmount();
                }
                this.countCache = amount;
            }
        }
        class_2680 state = this.method_11010();
        this.field_11863.method_8413(this.field_11867, state, state, 2);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        nbt.method_10544("count", this.countCache);
        nbt.method_10556("hidden", this.isHidden());
        return nbt;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("count")) {
            this.countCache = nbt.method_10537("count");
        }
        this.item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        this.hidden = nbt.method_10577("hidden");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("item", (class_2520)this.item.toNbt());
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        class_2680 state = this.method_11010();
        this.field_11863.method_8413(this.field_11867, state, state, 2);
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((drawer, dir) -> {
            Storage<ItemVariant> storage;
            class_1937 patt1607$temp = drawer.field_11863;
            if (patt1607$temp instanceof class_3218) {
                class_3218 serverWorld = (class_3218)patt1607$temp;
                storage = ShadowDrawerBlockEntity.createStorage(serverWorld, drawer.field_11867);
            } else {
                storage = Storage.empty();
            }
            return storage;
        }, ModBlocks.SHADOW_DRAWER_BLOCK_ENTITY);
    }

    public class ShadowDrawerStorage
    extends FilteringStorage<ItemVariant> {
        public ShadowDrawerStorage(Storage<ItemVariant> backingStorage) {
            super(backingStorage);
        }

        protected boolean canInsert(ItemVariant resource) {
            return resource.isBlank() || resource.equals(ShadowDrawerBlockEntity.this.item);
        }

        protected boolean canExtract(ItemVariant resource) {
            return resource.equals(ShadowDrawerBlockEntity.this.item);
        }
    }
}

