/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block.entity;

import io.github.mattidragon.extendeddrawers.block.DrawerBlock;
import io.github.mattidragon.extendeddrawers.config.CommonConfig;
import io.github.mattidragon.extendeddrawers.drawer.DrawerSlot;
import io.github.mattidragon.extendeddrawers.network.UpdateHandler;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class DrawerBlockEntity
extends class_2586 {
    public final int slots;
    public final DrawerSlot[] storages;
    public final CombinedStorage<ItemVariant, DrawerSlot> combinedStorage;

    public DrawerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.DRAWER_BLOCK_ENTITY, pos, state);
        this.slots = ((DrawerBlock)this.method_11010().method_26204()).slots;
        this.storages = new DrawerSlot[((DrawerBlock)this.method_11010().method_26204()).slots];
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i] = new DrawerSlot(this::onSlotChanged, ((CommonConfig)CommonConfig.HANDLE.get()).slotCountAffectsCapacity() ? 1.0 / (double)this.slots : 1.0);
        }
        this.combinedStorage = new CombinedStorage(new ArrayList<DrawerSlot>(List.of(this.storages)));
        this.sortSlots();
    }

    private void sortSlots() {
        this.combinedStorage.parts.sort(null);
    }

    private void onSlotChanged(boolean itemChanged) {
        this.method_5431();
        assert (this.field_11863 != null);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (itemChanged) {
                this.sortSlots();
            }
            UpdateHandler.scheduleUpdate(serverWorld, this.field_11867, itemChanged ? UpdateHandler.ChangeType.CONTENT : UpdateHandler.ChangeType.COUNT);
            class_2680 state = this.method_11010();
            this.field_11863.method_8413(this.field_11867, state, state, 2);
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    public boolean isEmpty() {
        for (DrawerSlot storage : this.storages) {
            if (storage.getUpgrade() == null && storage.isResourceBlank() && !storage.isHidden() && !storage.isLocked() && !storage.isVoiding()) continue;
            return false;
        }
        return true;
    }

    public void method_11014(class_2487 nbt) {
        List<class_2487> list = nbt.method_10554("items", 10).stream().map(class_2487.class::cast).toList();
        for (int i = 0; i < list.size(); ++i) {
            this.storages[i].readNbt(list.get(i));
        }
        this.sortSlots();
    }

    public void method_11007(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (DrawerSlot storage : this.storages) {
            class_2487 storageNbt = new class_2487();
            storage.writeNbt(storageNbt);
            list.add((Object)storageNbt);
        }
        nbt.method_10566("items", (class_2520)list);
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((drawer, dir) -> drawer.combinedStorage, ModBlocks.DRAWER_BLOCK_ENTITY);
    }
}

