/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import com.kneelawk.graphlib.graph.BlockNode;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.CreativeBreakBlocker;
import io.github.mattidragon.extendeddrawers.block.base.DrawerInteractionHandler;
import io.github.mattidragon.extendeddrawers.block.base.NetworkBlockWithEntity;
import io.github.mattidragon.extendeddrawers.block.base.NetworkComponent;
import io.github.mattidragon.extendeddrawers.block.entity.DrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.drawer.DrawerSlot;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.DrawerInteractionStatusManager;
import io.github.mattidragon.extendeddrawers.misc.DrawerRaycastUtil;
import io.github.mattidragon.extendeddrawers.network.node.DrawerBlockNode;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class DrawerBlock
extends NetworkBlockWithEntity<DrawerBlockEntity>
implements DrawerInteractionHandler,
CreativeBreakBlocker,
NetworkComponent {
    public static final class_2753 FACING = class_2741.field_12481;
    public final int slots;

    public DrawerBlock(class_4970.class_2251 settings, int slots) {
        super(settings);
        this.slots = slots;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt == null) {
            return;
        }
        List<ResourceAmount> list = nbt.method_10554("items", 10).stream().map(class_2487.class::cast).map(slot -> new ResourceAmount((Object)ItemVariant.fromNbt((class_2487)slot.method_10562("item")), slot.method_10537("amount"))).filter(resource -> !((ItemVariant)resource.resource()).isBlank()).toList();
        if (list.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)new class_2588("tooltip.extended_drawers.drawer_contents").method_27692(class_124.field_1080));
        for (ResourceAmount slot2 : list) {
            tooltip.add((class_2561)new class_2585(" - ").method_10852((class_2561)new class_2585(String.valueOf(slot2.amount()))).method_27693(" ").method_10852(((ItemVariant)slot2.resource()).toStack().method_7964()).method_27692(class_124.field_1080));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    protected class_2591<DrawerBlockEntity> getType() {
        return ModBlocks.DRAWER_BLOCK_ENTITY;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hit.method_17780() != state.method_11654((class_2769)FACING) || !player.method_7294() || hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        if (!(world instanceof class_3218)) {
            return class_1269.field_33562;
        }
        class_241 internalPos = DrawerRaycastUtil.calculateFaceLocation(pos, hit.method_17784(), hit.method_17780(), (class_2350)state.method_11654((class_2769)FACING));
        if (internalPos == null) {
            return class_1269.field_5811;
        }
        int slot = this.getSlot(internalPos);
        DrawerBlockEntity drawer = (DrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        class_1799 playerStack = player.method_5998(hand);
        DrawerSlot storage = drawer.storages[slot];
        if (playerStack.method_7960() && player.method_5715()) {
            boolean changeResult = storage.changeUpgrade(null, world, pos, hit.method_17780(), player);
            return changeResult ? class_1269.field_5812 : class_1269.field_5814;
        }
        boolean isDoubleClick = DrawerInteractionStatusManager.getAndResetInsertStatus(player, pos, slot);
        try (Transaction t = Transaction.openOuter();){
            int inserted;
            if (isDoubleClick) {
                if (storage.isResourceBlank()) {
                    class_1269 class_12692 = class_1269.field_5811;
                    return class_12692;
                }
                inserted = (int)StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), (Storage)storage, itemVariant -> true, (long)Long.MAX_VALUE, (TransactionContext)t);
            } else {
                if (playerStack.method_7960()) {
                    class_1269 class_12693 = class_1269.field_5811;
                    return class_12693;
                }
                inserted = (int)storage.insert(ItemVariant.of((class_1799)playerStack), (long)playerStack.method_7947(), (TransactionContext)t);
                playerStack.method_7934(inserted);
            }
            if (inserted == 0) {
                class_1269 class_12694 = class_1269.field_33562;
                return class_12694;
            }
            t.commit();
            class_1269 class_12695 = class_1269.field_21466;
            return class_12695;
        }
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_7294()) {
            return;
        }
        DrawerBlockEntity drawer = (DrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        class_3965 hit = DrawerRaycastUtil.getTarget(player, pos);
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_241 internalPos = DrawerRaycastUtil.calculateFaceLocation(pos, hit.method_17784(), hit.method_17780(), (class_2350)state.method_11654((class_2769)FACING));
        if (internalPos == null) {
            return;
        }
        int slot = this.getSlot(internalPos);
        DrawerSlot storage = drawer.storages[slot];
        if (storage.isResourceBlank()) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            ItemVariant item = storage.getItem();
            int extracted = (int)storage.extract(item, player.method_5715() ? (long)item.getItem().method_7882() : 1L, (TransactionContext)t);
            if (extracted == 0) {
                return;
            }
            player.method_31548().method_7398(item.toStack(extracted));
            t.commit();
        }
    }

    private int getSlot(class_241 facePos) {
        return switch (this.slots) {
            case 1 -> 0;
            case 2 -> {
                if (facePos.field_1343 < 0.5f) {
                    yield 0;
                }
                yield 1;
            }
            case 4 -> {
                if (facePos.field_1342 < 0.5f) {
                    if (facePos.field_1343 < 0.5f) {
                        yield 0;
                    }
                    yield 1;
                }
                if (facePos.field_1343 < 0.5f) {
                    yield 2;
                }
                yield 3;
            }
            default -> throw new IllegalStateException("unexpected drawer slot count");
        };
    }

    @Override
    public class_1269 toggleLock(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        DrawerSlot storage;
        class_241 facePos = DrawerRaycastUtil.calculateFaceLocation(pos, hitPos, side, (class_2350)state.method_11654((class_2769)FACING));
        if (facePos == null) {
            return class_1269.field_5811;
        }
        storage.setLocked(!(storage = ((DrawerBlockEntity)((Object)this.getBlockEntity((class_1937)world, (class_2338)pos))).storages[this.getSlot(facePos)]).isLocked());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 toggleVoid(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        DrawerSlot storage;
        class_241 facePos = DrawerRaycastUtil.calculateFaceLocation(pos, hitPos, side, (class_2350)state.method_11654((class_2769)FACING));
        if (facePos == null) {
            return class_1269.field_5811;
        }
        storage.setVoiding(!(storage = ((DrawerBlockEntity)((Object)this.getBlockEntity((class_1937)world, (class_2338)pos))).storages[this.getSlot(facePos)]).isVoiding());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 toggleHide(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        DrawerSlot storage;
        class_241 facePos = DrawerRaycastUtil.calculateFaceLocation(pos, hitPos, side, (class_2350)state.method_11654((class_2769)FACING));
        if (facePos == null) {
            return class_1269.field_5811;
        }
        storage.setHidden(!(storage = ((DrawerBlockEntity)((Object)this.getBlockEntity((class_1937)world, (class_2338)pos))).storages[this.getSlot(facePos)]).isHidden());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 upgrade(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side, class_1657 player, class_1799 stack) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_241 facePos = DrawerRaycastUtil.calculateFaceLocation(pos, hitPos, side, (class_2350)state.method_11654((class_2769)FACING));
        if (facePos == null) {
            return class_1269.field_5811;
        }
        DrawerSlot storage = ((DrawerBlockEntity)((Object)this.getBlockEntity((class_1937)world, (class_2338)pos))).storages[this.getSlot(facePos)];
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof UpgradeItem)) {
            ExtendedDrawers.LOGGER.warn("Expected drawer upgrade to be UpgradeItem but found " + stack.method_7909().getClass().getSimpleName() + " instead");
            return class_1269.field_5814;
        }
        UpgradeItem upgrade = (UpgradeItem)class_17922;
        boolean changed = storage.changeUpgrade(upgrade, world, pos, side, player);
        if (changed) {
            stack.method_7934(1);
        }
        return changed ? class_1269.field_5812 : class_1269.field_5814;
    }

    @Override
    public boolean shouldBlock(class_1937 world, class_2338 pos, class_2350 direction) {
        return world.method_8320(pos).method_11654((class_2769)FACING) == direction;
    }

    @Override
    public Collection<BlockNode> createNodes() {
        return List.of(new DrawerBlockNode());
    }
}

