/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mod.shared.network;

import io.netty.util.ByteProcessor;

public class VarintByteDecoder
implements ByteProcessor {
    private int readVarint;
    private int bytesRead;
    private DecodeResult result = DecodeResult.TOO_SHORT;

    public boolean process(byte k) {
        this.readVarint |= (k & 0x7F) << this.bytesRead++ * 7;
        if (this.bytesRead > 3) {
            this.result = DecodeResult.TOO_BIG;
            return false;
        }
        if ((k & 0x80) != 128) {
            this.result = DecodeResult.SUCCESS;
            return false;
        }
        return true;
    }

    public int readVarint() {
        return this.readVarint;
    }

    public int varintBytes() {
        return this.bytesRead;
    }

    public DecodeResult getResult() {
        return this.result;
    }

    public void reset() {
        this.readVarint = 0;
        this.bytesRead = 0;
        this.result = DecodeResult.TOO_SHORT;
    }

    public static enum DecodeResult {
        SUCCESS,
        TOO_SHORT,
        TOO_BIG;

    }
}

