/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.Identifiers;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.PlatformProxy;
import snownee.jade.util.WailaExceptionHandler;

public final class UsernameCache {
    private static Map<UUID, String> map = new HashMap<UUID, String>();
    private static Set<UUID> downloadingList = Collections.synchronizedSet(new HashSet());
    private static final Path saveFile = PlatformProxy.getConfigDirectory().toPath().resolve("jade/usernamecache.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private UsernameCache() {
    }

    public static void setUsername(UUID uuid, String username) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(username);
        if (username.equals(map.get(uuid))) {
            return;
        }
        map.put(uuid, username);
        UsernameCache.save();
    }

    public static boolean removeUsername(UUID uuid) {
        Objects.requireNonNull(uuid);
        if (map.remove(uuid) != null) {
            UsernameCache.save();
            return true;
        }
        return false;
    }

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        Objects.requireNonNull(uuid);
        String name = map.get(uuid);
        if (name == null && PluginConfig.INSTANCE.get(Identifiers.MC_ANIMAL_OWNER_FETCH_NAMES)) {
            UsernameCache.download(uuid);
        }
        return name;
    }

    public static boolean containsUUID(UUID uuid) {
        Objects.requireNonNull(uuid);
        return map.containsKey(uuid);
    }

    public static Map<UUID, String> getMap() {
        return ImmutableMap.copyOf(map);
    }

    public static void save() {
        new SaveThread(gson.toJson(map)).start();
    }

    public static void load() {
        if (!Files.exists(saveFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(saveFile, Charsets.UTF_8);){
            Type type = new TypeToken<Map<UUID, String>>(){}.getType();
            map = (Map)gson.fromJson((Reader)reader, type);
        }
        catch (JsonSyntaxException | IOException e) {
            Jade.LOGGER.error("Could not parse username cache file as valid json, deleting file {}", (Object)saveFile, (Object)e);
            WailaExceptionHandler.handleErr(e, null, null);
            try {
                Files.delete(saveFile);
            }
            catch (IOException e1) {
                Jade.LOGGER.error("Could not delete file {}", (Object)saveFile.toString());
            }
        }
        finally {
            if (map == null) {
                map = new HashMap<UUID, String>();
            }
        }
    }

    private static void download(UUID uuid) {
        if (downloadingList.contains(uuid)) {
            return;
        }
        downloadingList.add(uuid);
        new DownloadThread(uuid).start();
    }

    private static class SaveThread
    extends Thread {
        private final String data;

        public SaveThread(String data) {
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Path path = saveFile;
                synchronized (path) {
                    Files.write(saveFile, this.data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                Jade.LOGGER.error("Failed to save username cache to file!");
            }
        }
    }

    private static class DownloadThread
    extends Thread {
        private final UUID uuid;

        public DownloadThread(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public void run() {
            try {
                GameProfile profile = new GameProfile(this.uuid, "???");
                profile = class_310.method_1551().method_1495().fillProfileProperties(profile, true);
                if (profile.getName() != null && !profile.getName().equals("???")) {
                    UsernameCache.setUsername(profile.getId(), profile.getName());
                    downloadingList.remove(this.uuid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

