/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.LongMath;
import net.minecraft.class_2378;
import net.minecraft.class_3611;
import snownee.jade.overlay.DisplayHelper;

public class FluidTextHelper {
    private static final char[] SUPERSCRIPT = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char FRACTION_BAR = '\u2044';
    private static final char[] SUBSCRIPT = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};

    public static String toString(class_3611 fluid) {
        return class_2378.field_11154.method_10221((Object)fluid).toString();
    }

    public static String getUnicodeFraction(long numerator, long denominator, boolean simplify) {
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        StringBuilder numString = new StringBuilder();
        while (numerator > 0L) {
            numString.append(SUPERSCRIPT[(int)(numerator % 10L)]);
            numerator /= 10L;
        }
        StringBuilder denomString = new StringBuilder();
        while (denominator > 0L) {
            denomString.append(SUBSCRIPT[(int)(denominator % 10L)]);
            denominator /= 10L;
        }
        return numString.reverse().toString() + "\u2044" + denomString.reverse().toString();
    }

    public static String getUnicodeMillibuckets(long droplets, boolean simplify) {
        boolean hasDroplets;
        long mb = droplets / 81L;
        boolean bl = hasDroplets = droplets % 81L != 0L;
        if (!hasDroplets || droplets >= 8100000L) {
            return DisplayHelper.INSTANCE.humanReadableNumber(mb, "B", true);
        }
        return mb + " " + FluidTextHelper.getUnicodeFraction(droplets % 81L, 81L, simplify) + "mB";
    }

    private FluidTextHelper() {
    }
}

