/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeRenderBackgroundCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.config.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.Color;

public class OverlayRenderer {
    public static float ticks;
    public static int backgroundColorRaw;
    public static int gradientStartRaw;
    public static int gradientEndRaw;
    public static int stressedTextColorRaw;
    public static int normalTextColorRaw;
    public static boolean shown;
    public static float alpha;
    private static TooltipRenderer fadeTooltip;
    private static class_768 morphRect;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        return general.getDisplayMode() != IWailaConfig.DisplayMode.HOLD_KEY || JadeClient.showOverlay.method_1434();
    }

    public static boolean shouldShowImmediately(TooltipRenderer tooltipRenderer) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return false;
        }
        if (!ClientPlatformProxy.shouldShowWithOverlay(mc, mc.field_1755)) {
            return false;
        }
        if (mc.field_1755 instanceof BaseOptionsScreen) {
            class_768 position = tooltipRenderer.getPosition();
            class_1041 window = mc.method_22683();
            double x = mc.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
            double y = mc.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
            WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
            if (position.method_3318((int)(x += (double)((float)position.method_3319() * overlay.tryFlip(overlay.getAnchorX()))), (int)(y += (double)((float)position.method_3320() * overlay.getAnchorY())))) {
                return false;
            }
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (mc.field_1690.field_1866 && general.shouldHideFromDebug()) {
            return false;
        }
        if (mc.method_18506() != null || mc.field_1690.field_1842) {
            return false;
        }
        return !mc.field_1705.method_1750().field_2158 || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(class_4587 poseStack) {
        shown = false;
        boolean show = OverlayRenderer.shouldShow();
        TooltipRenderer tooltipRenderer = WailaTickHandler.instance().tooltipRenderer;
        float delta = class_310.method_1551().method_1534();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (overlay.getAnimation()) {
            if (tooltipRenderer == null) {
                tooltipRenderer = fadeTooltip;
            } else {
                fadeTooltip = tooltipRenderer;
            }
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (alpha < 0.1f || tooltipRenderer == null || !OverlayRenderer.shouldShowImmediately(tooltipRenderer)) {
            fadeTooltip = null;
            morphRect = null;
            return;
        }
        ticks += delta;
        class_310.method_1551().method_16011().method_15396("Jade Overlay");
        OverlayRenderer.renderOverlay(tooltipRenderer, poseStack);
        class_310.method_1551().method_16011().method_15407();
    }

    public static void renderOverlay(TooltipRenderer tooltip, class_4587 matrixStack) {
        class_768 rect;
        IWailaConfig.BossBarOverlapMode mode;
        matrixStack.method_22903();
        class_768 position = tooltip.getPosition();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        if (!overlay.getSquare()) {
            position.method_35782(position.method_3319() + 2);
            position.method_35783(position.method_3320() + 2);
            position.method_35779(position.method_3321() + 1, position.method_3322() + 1);
        }
        if ((mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode()) == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (rect = ClientPlatformProxy.getBossBarRect()) != null) {
            int tw = position.method_3319();
            int th = position.method_3320();
            int rw = rect.method_3319();
            int rh = rect.method_3320();
            int tx = position.method_3321();
            int ty = position.method_3322();
            int rx = rect.method_3321();
            int ry = rect.method_3322();
            if ((rw += rx) > tx && (rh += ry) > ty && (tw += tx) > rx && (th += ty) > ry) {
                position.method_35781(rect.method_3320());
            }
        }
        if (morphRect == null) {
            morphRect = new class_768(position.method_3321(), position.method_3322(), position.method_3319(), position.method_3320());
        } else {
            OverlayRenderer.chase(position, class_768::method_3321, arg_0 -> ((class_768)morphRect).method_35778(arg_0));
            OverlayRenderer.chase(position, class_768::method_3322, arg_0 -> ((class_768)morphRect).method_35781(arg_0));
            OverlayRenderer.chase(position, class_768::method_3319, arg_0 -> ((class_768)morphRect).method_35782(arg_0));
            OverlayRenderer.chase(position, class_768::method_3320, arg_0 -> ((class_768)morphRect).method_35783(arg_0));
        }
        JadeBeforeRenderCallback.ColorSetting colorSetting = new JadeBeforeRenderCallback.ColorSetting();
        colorSetting.alpha = overlay.getAlpha();
        colorSetting.backgroundColor = backgroundColorRaw;
        colorSetting.gradientStart = gradientStartRaw;
        colorSetting.gradientEnd = gradientEndRaw;
        for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.INSTANCE.beforeRenderCallback.callbacks()) {
            if (!callback2.beforeRender(tooltip.getTooltip(), morphRect, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            matrixStack.method_22909();
            return;
        }
        matrixStack.method_22904((double)morphRect.method_3321(), (double)morphRect.method_3322(), 1.0);
        float scale = overlay.getOverlayScale();
        class_1041 window = class_310.method_1551().method_22683();
        float thresholdHeight = (float)window.method_4502() * overlay.getAutoScaleThreshold();
        if ((float)position.method_3320() * scale > thresholdHeight) {
            scale = Math.max(scale * 0.5f, thresholdHeight / (float)position.method_3320());
        }
        if (scale != 1.0f) {
            matrixStack.method_22905(scale, scale, 1.0f);
        }
        matrixStack.method_22904((double)((int)((float)(-morphRect.method_3319()) * overlay.tryFlip(overlay.getAnchorX()))), (double)((int)((float)(-morphRect.method_3320()) * overlay.getAnchorY())), 0.0);
        boolean doDefault = true;
        colorSetting.alpha *= alpha;
        for (JadeRenderBackgroundCallback callback3 : WailaClientRegistration.INSTANCE.renderBackgroundCallback.callbacks()) {
            if (!callback3.onRender(tooltip, morphRect, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            doDefault = false;
            break;
        }
        if (doDefault && colorSetting.alpha > 0.0f) {
            OverlayRenderer.drawTooltipBox(matrixStack, 0, 0, morphRect.method_3319(), morphRect.method_3320(), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.backgroundColor, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientStart, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientEnd, colorSetting.alpha), overlay.getSquare());
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(matrixStack);
        RenderSystem.disableBlend();
        WailaClientRegistration.INSTANCE.afterRenderCallback.call(callback -> callback.afterRender(tooltip.getTooltip(), morphRect, matrixStack, ObjectDataCenter.get()));
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech() && class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_8510() % 5L == 0L) {
            WailaTickHandler.narrate(tooltip.getTooltip(), true);
        }
        shown = true;
    }

    private static void chase(class_768 pos, ToIntFunction<class_768> getter, IntConsumer setter) {
        if (Jade.CONFIG.get().getOverlay().getAnimation()) {
            int value = getter.applyAsInt(morphRect);
            int target = getter.applyAsInt(pos);
            float diff = target - value;
            if (diff == 0.0f) {
                return;
            }
            float delta = class_310.method_1551().method_1534() * 2.0f;
            if (delta < 1.0f) {
                diff *= delta;
            }
            if (class_3532.method_15379((float)diff) < 1.0f) {
                diff = diff > 0.0f ? 1.0f : -1.0f;
            }
            setter.accept((int)((float)value + diff));
        } else {
            setter.accept(getter.applyAsInt(pos));
        }
    }

    public static void drawTooltipBox(class_4587 matrixStack, int x, int y, int w, int h, int bg, int grad1, int grad2, boolean square) {
        if (!square) {
            w -= 2;
            h -= 2;
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + 1, y + 1, w - 2, h - 2, bg, bg);
        if (!square) {
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y - 1, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x - 1, y, 1.0f, h, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w, y, 1.0f, h, bg, bg);
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w - 1, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y, w, 1.0f, grad1, grad1);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h - 1, w, 1.0f, grad2, grad2);
    }

    public static void updateTheme() {
        Theme theme = Jade.CONFIG.get().getOverlay().getTheme();
        backgroundColorRaw = Color.valueOf(theme.backgroundColor).toInt();
        gradientEndRaw = Color.valueOf(theme.gradientEnd).toInt();
        gradientStartRaw = Color.valueOf(theme.gradientStart).toInt();
        normalTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.valueOf(theme.normalTextColor).toInt(), 1.0f);
        stressedTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.valueOf(theme.stressedTextColor).toInt(), 1.0f);
    }
}

