/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum PotionEffectsProvider implements IEntityComponentProvider,
IServerDataProvider<class_1297>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().method_10545("Potions")) {
            return;
        }
        IElementHelper helper = tooltip.getElementHelper();
        ITooltip box = helper.tooltip();
        class_2499 list = accessor.getServerData().method_10554("Potions", 10);
        class_2561[] lines = new class_2561[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            class_2487 compound = list.method_10602(i);
            int duration = compound.method_10550("Duration");
            class_2588 name = new class_2588(compound.method_10558("Name"));
            String amplifierKey = "potion.potency." + compound.method_10550("Amplifier");
            Object amplifier = class_1074.method_4663((String)amplifierKey) ? new class_2588(amplifierKey) : new class_2585(Integer.toString(compound.method_10550("Amplifier")));
            class_2588 s = new class_2588("jade.potion", new Object[]{name, amplifier, PotionEffectsProvider.getPotionDurationString(duration)});
            box.add((class_2561)s.method_27692(compound.method_10577("Bad") ? class_124.field_1061 : class_124.field_1060));
        }
        tooltip.add(helper.box(box));
    }

    public static String getPotionDurationString(int duration) {
        if (duration >= Short.MAX_VALUE) {
            return "**:**";
        }
        int i = class_3532.method_15375((float)duration);
        return PotionEffectsProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    @Override
    public void appendServerData(class_2487 tag, class_3222 player, class_1937 arg2, class_1297 entity, boolean showDetails) {
        class_1309 living = (class_1309)entity;
        Collection effects = living.method_6026();
        if (effects.isEmpty()) {
            return;
        }
        class_2499 list = new class_2499();
        for (class_1293 effect : effects) {
            class_2487 compound = new class_2487();
            compound.method_10582("Name", effect.method_5586());
            compound.method_10569("Amplifier", effect.method_5578());
            int duration = Math.min(Short.MAX_VALUE, effect.method_5584());
            compound.method_10569("Duration", duration);
            compound.method_10556("Bad", effect.method_5579().method_18792() == class_4081.field_18272);
            list.add((Object)compound);
        }
        tag.method_10566("Potions", (class_2520)list);
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.MC_POTION_EFFECTS;
    }
}

