/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.leaves_us_in_peace;

import java.util.Optional;
import java.util.Random;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.sssubtlety.leaves_us_in_peace.Config;

public final class FeatureControl {
    private static final Config CONFIG_INSTANCE;

    public static boolean isConfigLoaded() {
        return CONFIG_INSTANCE != null;
    }

    public static boolean shouldMatchLeavesTypes() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.matchLeavesTypes;
    }

    public static boolean shouldUnknownLeavesOnlyMatchSelf() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.unknownLeavesOnlyMatchSelf;
    }

    public static boolean shouldMatchLogsToLeaves() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.matchLogsToLeaves;
    }

    public static boolean shouldIgnorePersistentLeaves() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.ignorePersistentLeaves;
    }

    public static boolean shouldAccelerateLeavesDecay() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.accelerateLeavesDecay;
    }

    public static int getDecayDelay(Random random) {
        int maxDecayDelay;
        int minDecayDelay;
        if (CONFIG_INSTANCE == null) {
            minDecayDelay = 10;
            maxDecayDelay = 60;
        } else {
            minDecayDelay = FeatureControl.CONFIG_INSTANCE.decayDelay.minimum;
            maxDecayDelay = FeatureControl.CONFIG_INSTANCE.decayDelay.maximum;
        }
        return minDecayDelay < maxDecayDelay ? random.nextInt(minDecayDelay, maxDecayDelay + 1) : maxDecayDelay;
    }

    public static boolean shouldUpdateDiagonalLeaves() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.updateDiagonalLeaves;
    }

    public static boolean shouldDoDecayingLeavesEffects() {
        return CONFIG_INSTANCE == null ? false : FeatureControl.CONFIG_INSTANCE.doDecayingLeavesEffects;
    }

    public static boolean shouldFetchTranslationUpdates() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.fetchTranslationUpdates;
    }

    public static boolean isMatchingLeaves(class_6862<class_2248> leavesTag, class_2680 state, class_2680 currentLeaves) {
        if (state.method_26204() == currentLeaves.method_26204()) {
            return true;
        }
        if (leavesTag == null) {
            return !FeatureControl.shouldUnknownLeavesOnlyMatchSelf();
        }
        return state.method_26164(leavesTag);
    }

    public static void init() {
    }

    private FeatureControl() {
    }

    static {
        boolean shouldLoadConfig = false;
        Optional optModContainer = FabricLoader.getInstance().getModContainer("cloth-config");
        if (optModContainer.isPresent()) {
            try {
                shouldLoadConfig = VersionPredicate.parse((String)">=6.1.48").test((Object)((ModContainer)optModContainer.get()).getMetadata().getVersion());
            }
            catch (VersionParsingException e) {
                e.printStackTrace();
            }
        }
        CONFIG_INSTANCE = shouldLoadConfig ? (Config)AutoConfig.register(Config.class, GsonConfigSerializer::new).getConfig() : null;
    }

    public static class Defaults {
        public static final boolean matchLeavesTypes = true;
        public static final boolean unknownLeavesOnlyMatchSelf = true;
        public static final boolean matchLogsToLeaves = true;
        public static final boolean ignorePersistentLeaves = true;
        public static final boolean accelerateLeavesDecay = true;
        public static final int minDecayDelay = 10;
        public static final int maxDecayDelay = 60;
        public static final boolean updateDiagonalLeaves = true;
        public static final boolean doDecayingLeavesEffects = false;
        public static final boolean fetchTranslationUpdates = true;

        private Defaults() {
        }
    }
}

