/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;

public class PlayerGUIOperationMessage
extends BaseC2SMessage {
    private final Operation op;
    private final List<UUID> targets;

    public PlayerGUIOperationMessage(Operation op, UUID target) {
        this.op = op;
        this.targets = List.of(target);
    }

    public PlayerGUIOperationMessage(Operation op, Collection<GameProfile> targets) {
        this.op = op;
        this.targets = targets.stream().map(GameProfile::getId).toList();
    }

    public PlayerGUIOperationMessage(class_2540 buf) {
        this.op = (Operation)buf.method_10818(Operation.class);
        this.targets = new ArrayList<UUID>();
        int n = buf.method_10816();
        for (int i = 0; i < n; ++i) {
            this.targets.add(buf.method_10790());
        }
    }

    public MessageType getType() {
        return FTBTeamsNet.PLAYER_GUI_OPERATION;
    }

    public void write(class_2540 buf) {
        buf.method_10817((Enum)this.op);
        buf.method_10804(this.targets.size());
        this.targets.forEach(arg_0 -> ((class_2540)buf).method_10797(arg_0));
    }

    public void handle(NetworkManager.PacketContext context) {
        class_1657 class_16572 = context.getPlayer();
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        UUID senderId = context.getPlayer().method_5667();
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(senderId);
        if (team instanceof PartyTeam) {
            PartyTeam partyTeam = (PartyTeam)team;
            TeamRank senderRank = partyTeam.getHighestRank(serverPlayer.method_5667());
            this.targets.forEach(target -> this.processTarget(serverPlayer, senderRank, partyTeam, (UUID)target));
        }
    }

    private void processTarget(class_3222 sourcePlayer, TeamRank senderRank, PartyTeam partyTeam, UUID targetId) {
        if (this.op.requireSameTeam() && !FTBTeamsAPI.arePlayersInSameTeam(sourcePlayer.method_5667(), targetId)) {
            return;
        }
        TeamRank targetRank = partyTeam.getHighestRank(targetId);
        FTBTeams.LOGGER.debug("received teams operation msg {} from {} (rank {}), team {}, target {} (rank {})", (Object)this.op, (Object)sourcePlayer.method_5667(), (Object)senderRank, (Object)partyTeam.getName().getString(), (Object)targetId, (Object)targetRank);
        try {
            List<GameProfile> targetProfile = List.of(new GameProfile(targetId, null));
            switch (this.op) {
                case KICK: {
                    if (senderRank.getPower() <= targetRank.getPower()) break;
                    partyTeam.kick(sourcePlayer, targetProfile);
                    break;
                }
                case PROMOTE: {
                    if (!senderRank.is(TeamRank.OWNER) || !targetRank.is(TeamRank.MEMBER)) break;
                    partyTeam.promote(sourcePlayer, targetProfile);
                    break;
                }
                case DEMOTE: {
                    if (!senderRank.is(TeamRank.OWNER) || !targetRank.is(TeamRank.OFFICER)) break;
                    partyTeam.demote(sourcePlayer, targetProfile);
                    break;
                }
                case TRANSFER_OWNER: {
                    if (!senderRank.is(TeamRank.OWNER)) break;
                    class_3222 p = partyTeam.manager.server.method_3760().method_14602(targetId);
                    if (p != null) {
                        partyTeam.transferOwnership(sourcePlayer, p);
                    }
                    break;
                }
                case LEAVE: {
                    partyTeam.leave(sourcePlayer);
                    break;
                }
                case INVITE: {
                    if (!senderRank.is(TeamRank.OFFICER)) break;
                    class_3222 p = partyTeam.manager.server.method_3760().method_14602(targetId);
                    if (p != null) {
                        partyTeam.invite(sourcePlayer, List.of(p.method_7334()));
                    }
                    break;
                }
                case ADD_ALLY: {
                    if (!senderRank.is(TeamRank.OFFICER) || !targetRank.is(TeamRank.NONE)) break;
                    partyTeam.addAlly(sourcePlayer.method_5671(), targetProfile);
                    break;
                }
                case REMOVE_ALLY: {
                    if (!senderRank.is(TeamRank.OFFICER) || !targetRank.is(TeamRank.ALLY)) break;
                    partyTeam.removeAlly(sourcePlayer.method_5671(), targetProfile);
                }
            }
        }
        catch (CommandSyntaxException e) {
            sourcePlayer.method_7353((class_2561)new class_2585(e.getMessage()).method_27692(class_124.field_1061), false);
        }
    }

    public static enum Operation {
        PROMOTE(true),
        DEMOTE(true),
        LEAVE(true),
        KICK(true),
        TRANSFER_OWNER(true),
        INVITE(false),
        ADD_ALLY(false),
        REMOVE_ALLY(false);

        private final boolean requireSameTeam;

        private Operation(boolean requireSameTeam) {
            this.requireSameTeam = requireSameTeam;
        }

        boolean requireSameTeam() {
            return this.requireSameTeam;
        }

        public void sendMessage(KnownClientPlayer target) {
            new PlayerGUIOperationMessage(this, target.uuid).sendToServer();
        }
    }
}

