/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class PartyTeam
extends Team {
    UUID owner = class_156.field_25140;

    public PartyTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PARTY;
    }

    @Override
    protected void serializeExtraNBT(class_2487 tag) {
        tag.method_10582("owner", this.owner.toString());
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.owner = UUID.fromString(tag.method_10558("owner"));
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (this.owner.equals(playerId)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    public boolean isOwner(UUID profile) {
        return this.owner.equals(profile);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    public int join(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        Team oldTeam = this.manager.getPlayerTeam(player);
        if (!oldTeam.getType().isPlayer()) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        UUID id = player.method_5667();
        ((PlayerTeam)oldTeam).actualTeam = this;
        this.ranks.put(id, TeamRank.MEMBER);
        this.sendMessage(class_156.field_25140, (class_2561)new class_2588("ftbteams.message.joined", new Object[]{player.method_5477()}).method_27692(class_124.field_1060));
        this.save();
        oldTeam.ranks.remove(id);
        oldTeam.save();
        ((PlayerTeam)oldTeam).updatePresence();
        this.manager.syncTeamsToAll(this, oldTeam);
        this.changedTeam(oldTeam, id, player, false);
        return 1;
    }

    public int invite(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            if (FTBTeamsAPI.getManager().getPlayerTeam(player.getId()) instanceof PartyTeam) {
                throw TeamArgument.PLAYER_IN_PARTY.create((Object)player.getName());
            }
            this.ranks.put(player.getId(), TeamRank.INVITED);
            this.save();
            this.sendMessage(from.method_5667(), (class_2561)new class_2588("ftbteams.message.invited", new Object[]{new class_2585(player.getName()).method_27692(class_124.field_1054)}).method_27692(class_124.field_1060));
            class_3222 p = FTBTUtils.getPlayerByUUID(this.manager.getServer(), player.getId());
            if (p == null) continue;
            p.method_9203((class_2561)new class_2588("ftbteams.message.invite_sent", new Object[]{from.method_5477().method_27661().method_27692(class_124.field_1054)}), class_156.field_25140);
            class_5250 acceptButton = new class_2588("ftbteams.accept").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/ftbteams party join " + this.getStringID())));
            class_5250 declineButton = new class_2588("ftbteams.decline").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/ftbteams party deny_invite " + this.getStringID())));
            p.method_9203((class_2561)new class_2585("[").method_10852((class_2561)acceptButton).method_27693("] [").method_10852((class_2561)declineButton).method_27693("]"), class_156.field_25140);
        }
        return 1;
    }

    public int kick(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            UUID id = player.getId();
            Team oldTeam = this.manager.getPlayerTeam(id);
            if (oldTeam != this) {
                throw TeamArgument.NOT_IN_PARTY.create();
            }
            if (this.isOwner(id)) {
                throw TeamArgument.CANT_KICK_OWNER.create();
            }
            PlayerTeam team = this.manager.getInternalPlayerTeam(id);
            team.actualTeam = team;
            class_3222 playerEntity = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            team.ranks.put(id, TeamRank.OWNER);
            this.sendMessage(from.method_5667(), (class_2561)new class_2588("ftbteams.message.kicked", new Object[]{this.manager.getName(id).method_27661().method_27692(class_124.field_1054), this.getName()}).method_27692(class_124.field_1065));
            team.save();
            this.ranks.remove(id);
            this.save();
            team.updatePresence();
            this.manager.syncTeamsToAll(this, team);
            if (playerEntity != null) {
                playerEntity.method_7353((class_2561)new class_2588("ftbteams.message.kicked", new Object[]{playerEntity.method_5477().method_27661().method_27692(class_124.field_1054), this.getName().method_27661().method_27692(class_124.field_1075)}), false);
                this.updateCommands(playerEntity);
            }
            team.changedTeam(this, id, playerEntity, false);
        }
        return 1;
    }

    public int promote(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        boolean changesMade = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.getHighestRank(id) == TeamRank.MEMBER) {
                this.ranks.put(id, TeamRank.OFFICER);
                this.sendMessage(from.method_5667(), (class_2561)new class_2588("ftbteams.message.promoted", new Object[]{this.manager.getName(id).method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1060));
                changesMade = true;
                continue;
            }
            throw TeamArgument.NOT_MEMBER.create((Object)this.manager.getName(id), (Object)this.getName());
        }
        if (changesMade) {
            this.save();
            this.manager.syncTeamsToAll(this);
        }
        return 1;
    }

    public int demote(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        boolean changesMade = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.getHighestRank(id) == TeamRank.OFFICER) {
                this.ranks.put(id, TeamRank.MEMBER);
                this.sendMessage(from.method_5667(), (class_2561)new class_2588("ftbteams.message.demoted", new Object[]{this.manager.getName(id).method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1065));
                changesMade = true;
                continue;
            }
            throw TeamArgument.NOT_OFFICER.create((Object)this.manager.getName(id), (Object)this.getName());
        }
        if (changesMade) {
            this.manager.syncTeamsToAll(this);
        }
        return 1;
    }

    public int transferOwnership(class_3222 from, class_3222 to) throws CommandSyntaxException {
        if (!this.getOnlineMembers().contains(to)) {
            throw TeamArgument.NOT_MEMBER.create((Object)to.method_5476(), (Object)this.getName());
        }
        if (from == to) {
            from.method_9203((class_2561)new class_2585("What."), class_156.field_25140);
            return 0;
        }
        this.ranks.put(this.owner, TeamRank.OFFICER);
        this.owner = to.method_5667();
        this.ranks.put(this.owner, TeamRank.OWNER);
        this.save();
        ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent(this, from, to));
        this.sendMessage(from.method_5667(), (class_2561)new class_2588("ftbteams.message.transfer_owner", new Object[]{to.method_5476().method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1060));
        this.updateCommands(from);
        this.updateCommands(to);
        this.manager.syncTeamsToAll(this);
        return 1;
    }

    public int leave(class_3222 player) throws CommandSyntaxException {
        UUID id = player.method_5667();
        if (this.isOwner(id) && this.getMembers().size() > 1) {
            throw TeamArgument.OWNER_CANT_LEAVE.create();
        }
        PlayerTeam team = this.manager.getInternalPlayerTeam(id);
        team.actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        this.sendMessage(class_156.field_25140, (class_2561)new class_2588("ftbteams.message.left_party", new Object[]{player.method_5477().method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1065));
        team.save();
        this.ranks.remove(id);
        this.manager.save();
        boolean deleted = false;
        if (this.getMembers().isEmpty()) {
            deleted = true;
            this.manager.saveNow();
            this.manager.teamMap.remove(this.getId());
            String fn = this.getId() + ".snbt";
            try {
                Path dir = this.manager.server.method_27050(TeamManager.FOLDER_NAME).resolve("deleted");
                if (Files.notExists(dir, new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                Files.move(this.manager.server.method_27050(TeamManager.FOLDER_NAME).resolve("party/" + fn), dir.resolve(fn), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(this.manager.server.method_27050(TeamManager.FOLDER_NAME).resolve("party/" + fn));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        team.updatePresence();
        this.manager.syncTeamsToAll(this, team);
        team.changedTeam(this, id, player, deleted);
        return 1;
    }

    public int addAlly(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.method_9228() == null ? class_156.field_25140 : source.method_9228().method_5667();
        ArrayList<GameProfile> addedPlayers = new ArrayList<GameProfile>();
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.isAlly(id)) continue;
            this.ranks.put(id, TeamRank.ALLY);
            this.sendMessage(from, (class_2561)new class_2588("ftbteams.message.add_ally", new Object[]{this.manager.getName(id).method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1060));
            addedPlayers.add(player);
            class_3222 invitedPlayer = this.manager.getServer().method_3760().method_14602(id);
            if (invitedPlayer == null) continue;
            invitedPlayer.method_7353((class_2561)new class_2588("ftbteams.message.now_allied", new Object[]{this.getDisplayName()}).method_27692(class_124.field_1060), false);
        }
        if (!addedPlayers.isEmpty()) {
            this.save();
            this.manager.syncTeamsToAll(this);
            ((Consumer)TeamEvent.ADD_ALLY.invoker()).accept(new TeamAllyEvent(this, addedPlayers, true));
            return 1;
        }
        return 0;
    }

    public int removeAlly(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.method_9228() == null ? class_156.field_25140 : source.method_9228().method_5667();
        ArrayList<GameProfile> removedPlayers = new ArrayList<GameProfile>();
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (!this.isAlly(id) || this.isMember(id)) continue;
            this.ranks.remove(id);
            this.sendMessage(from, (class_2561)new class_2588("ftbteams.message.remove_ally", new Object[]{this.manager.getName(id).method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1065));
            removedPlayers.add(player);
            class_3222 removedPlayer = this.manager.getServer().method_3760().method_14602(id);
            if (removedPlayer == null) continue;
            removedPlayer.method_7353((class_2561)new class_2588("ftbteams.message.no_longer_allied", new Object[]{this.getDisplayName()}).method_27692(class_124.field_1065), false);
        }
        if (!removedPlayers.isEmpty()) {
            this.save();
            this.manager.syncTeamsToAll(this);
            ((Consumer)TeamEvent.REMOVE_ALLY.invoker()).accept(new TeamAllyEvent(this, removedPlayers, false));
            return 1;
        }
        return 0;
    }

    public int listAllies(class_2168 source) throws CommandSyntaxException {
        source.method_9226((class_2561)new class_2585("Allies:"), false);
        boolean any = false;
        for (Map.Entry<UUID, TeamRank> entry : this.getRanked(TeamRank.ALLY).entrySet()) {
            if (entry.getValue().is(TeamRank.MEMBER)) continue;
            source.method_9226(this.manager.getName(entry.getKey()), false);
            any = true;
        }
        if (!any) {
            source.method_9226((class_2561)new class_2585("None"), false);
        }
        return 1;
    }
}

