/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.NordButton;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftbteams.client.InvitationSetup;
import dev.ftb.mods.ftbteams.client.InvitedButton;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_4587;

public abstract class BaseInvitationScreen
extends BaseScreen
implements InvitationSetup {
    protected final Set<KnownClientPlayer> available = new HashSet<KnownClientPlayer>();
    protected final Set<GameProfile> invites = new HashSet<GameProfile>();
    private Panel playerPanel;
    private Button executeButton;
    private Button closeButton;
    private final class_2561 title;

    public BaseInvitationScreen(class_2561 title) {
        this.title = title;
        ClientTeamManager.INSTANCE.knownPlayers.forEach((id, known) -> {
            if (this.shouldIncludePlayer((KnownClientPlayer)known)) {
                this.available.add((KnownClientPlayer)known);
            }
        });
    }

    protected abstract boolean shouldIncludePlayer(KnownClientPlayer var1);

    protected abstract ExecuteButton makeExecuteButton();

    public boolean onInit() {
        this.setWidth(200);
        this.setHeight(this.getScreen().method_4502() * 3 / 4);
        return true;
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((class_4587)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)NordColors.POLAR_NIGHT_0, (boolean)true);
        NordColors.POLAR_NIGHT_0.draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
        NordColors.POLAR_NIGHT_1.draw(matrixStack, x + this.playerPanel.posX, y + this.playerPanel.posY, this.playerPanel.width, this.playerPanel.height);
        NordColors.POLAR_NIGHT_0.draw(matrixStack, x + 1, y + h - 20, w - 2, 18);
    }

    public void drawForeground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawString(matrixStack, (Object)this.title, (float)x + (float)w / 2.0f, (float)(y + 5), NordColors.SNOW_STORM_1, 4);
    }

    public void addWidgets() {
        this.closeButton = new SimpleButton((Panel)this, (class_2561)new class_2588("gui.cancel"), Icons.CANCEL.withTint(NordColors.SNOW_STORM_2), (simpleButton, mouseButton) -> this.closeGui()){

            public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
                this.drawIcon(matrixStack, theme, x, y, w, h);
            }
        };
        this.add((Widget)this.closeButton);
        this.playerPanel = new PlayerButtonPanel();
        this.add((Widget)this.playerPanel);
        this.executeButton = this.makeExecuteButton();
        this.add((Widget)this.executeButton);
    }

    public void alignWidgets() {
        this.closeButton.setPosAndSize(this.width - 20, 2, 16, 16);
        this.playerPanel.setPosAndSize(2, 20, this.width - 4, this.height - 40);
        this.executeButton.setPosAndSize(60, this.height - 18, 80, 16);
    }

    @Override
    public boolean isInvited(GameProfile profile) {
        return this.invites.contains(profile);
    }

    @Override
    public void setInvited(GameProfile profile, boolean invited) {
        if (invited) {
            this.invites.add(profile);
        } else {
            this.invites.remove(profile);
        }
    }

    private class PlayerButtonPanel
    extends Panel {
        public PlayerButtonPanel() {
            super((Panel)BaseInvitationScreen.this);
        }

        public void addWidgets() {
            if (BaseInvitationScreen.this.available.isEmpty()) {
                this.add((Widget)new TextField((Panel)this).setText((class_2561)new class_2588("ftbteams.gui.no_players").method_27692(class_124.field_1056)).addFlags(4));
            } else {
                BaseInvitationScreen.this.available.forEach(player -> this.add((Widget)new InvitedButton(this, BaseInvitationScreen.this, (KnownClientPlayer)player)));
            }
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(2, 1, 2));
            this.widgets.forEach(w -> w.setX(4));
        }

        public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_2.draw(matrixStack, x, y, w, h);
        }
    }

    protected abstract class ExecuteButton
    extends NordButton {
        private final class_2561 titleDark;
        private final Runnable callback;

        public ExecuteButton(class_2561 txt, Icon icon, Runnable callback) {
            super((Panel)BaseInvitationScreen.this, txt, icon);
            this.titleDark = this.title.method_27661().method_27696(class_2583.field_24360.method_36139(NordColors.POLAR_NIGHT_0.rgb()));
            this.callback = callback;
        }

        public void onClicked(MouseButton button) {
            if (this.isEnabled()) {
                this.callback.run();
            }
        }

        public class_2561 getTitle() {
            return this.isEnabled() ? this.title : this.titleDark;
        }

        public boolean renderTitleInCenter() {
            return true;
        }
    }
}

