/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Statistics;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class StatisticsCommand {
    private static final String[] SUB_COMMANDS = new String[]{"entities", "block-entities"};

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)class_2170.method_9247((String)"statistics").requires(Permission.require("command.statistics", 2));
        statistics.executes(ctx -> StatisticsCommand.displayOverview((class_2168)ctx.getSource()));
        int i = 0;
        while (i < SUB_COMMANDS.length) {
            int index = i++;
            statistics.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)SUB_COMMANDS[index]).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"byType").executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, false, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, false, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, 1, class_2186.method_9315((CommandContext)ctx, (String)"player")))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), class_2186.method_9315((CommandContext)ctx, (String)"player"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"byPlayer").executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, true, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<class_2168>)ctx, index, true, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
        }
        dispatcher.register(statistics);
    }

    private static int display(CommandContext<class_2168> context, int index, int page) {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return StatisticsCommand.display(context, index, false, page, player);
        }
        return StatisticsCommand.display(context, index, false, page);
    }

    private static int display(CommandContext<class_2168> context, int index, boolean byPlayer, int page) {
        return StatisticsCommand.display(context, index, byPlayer, page, null);
    }

    private static int display(CommandContext<class_2168> context, int index, int page, @Nullable class_3222 player) {
        return StatisticsCommand.display(context, index, false, page, player);
    }

    private static int display(CommandContext<class_2168> context, int index, boolean byPlayer, int page, @Nullable class_3222 player) {
        return switch (index) {
            case 0 -> StatisticsCommand.displayEntities(context, byPlayer, page, player);
            case 1 -> StatisticsCommand.displayBlockEntities(context, byPlayer, page, player);
            default -> throw new IllegalStateException("Unexpected value: " + index);
        };
    }

    private static int displayOverview(class_2168 source) {
        double mspt = DynamicManager.getInstance(source.method_9211()).getAverageTickTime();
        double tps = mspt != 0.0 ? Math.min(1000.0 / mspt, 20.0) : 20.0;
        Statistics statistics = Statistics.getInstance(source.method_9211());
        class_2561 component = Formatter.parse(Formatter.line(CommandConfig.STATS_TITLE.get(), 40, source.method_9228() instanceof class_3222) + "\n" + CommandConfig.STATS_CONTENT.get().replace("${tps}", String.format("%.2f", tps)).replace("${mspt}", String.format("%.2f", mspt)).replace("${chunk_count}", String.valueOf(statistics.getChunkCount(true))).replace("${entity_count}", String.valueOf(statistics.getAllEntities().size())).replace("${block_entity_count}", String.valueOf(statistics.getAllBlockEntities().size())));
        source.method_9226(component, false);
        return 1;
    }

    private static int displayEntities(CommandContext<class_2168> context, boolean byPlayer, int page, @Nullable class_3222 player) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, Integer> map = byPlayer ? statistics.getEntitiesByPlayer(server.method_3760().method_14571()) : statistics.getEntitiesByType(player == null ? statistics.getAllEntities() : statistics.getEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, map, false, byPlayer, page, player);
        return 1;
    }

    private static int displayBlockEntities(CommandContext<class_2168> context, boolean byPlayer, int page, @Nullable class_3222 player) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, Integer> map = byPlayer ? statistics.getBlockEntitiesByPlayer(server.method_3760().method_14571()) : statistics.getBlockEntitiesByType(player == null ? statistics.getAllBlockEntities() : statistics.getBlockEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, map, true, byPlayer, page, player);
        return 1;
    }

    private static void displayFeedback(CommandContext<class_2168> context, Map<String, Integer> map, boolean isBlockEntity, boolean byPlayer, int page, @Nullable class_3222 player) {
        class_2168 source = (class_2168)context.getSource();
        StringBuilder builder = new StringBuilder(StatisticsCommand.createHeader(isBlockEntity, byPlayer, source.method_9228() instanceof class_3222, player));
        boolean success = Util.iteratePage(Util.sortByValue(map), page, 8, (entry, index) -> builder.append(StatisticsCommand.createEntry(entry, index, isBlockEntity, byPlayer)));
        if (success) {
            builder.append("\n").append(StatisticsCommand.createFooter(page, Util.getPage(map.size(), 8), isBlockEntity, context));
            source.method_9226(Formatter.parse(builder.toString()), false);
        } else if (page == 1) {
            source.method_9213((class_2561)new class_2585(isBlockEntity ? "No block entities were found!" : "No entities were found!"));
        } else {
            source.method_9213((class_2561)new class_2585("Page doesn't exist!"));
        }
    }

    private static String createEntry(Map.Entry<String, Integer> entry, int index, boolean isBlockEntity, boolean byPlayer) {
        Object string = "\n" + CommandConfig.STATS_PAGE_CONTENT.get().replace("${name}", entry.getKey()).replace("${index}", String.valueOf(index)).replace("${count}", String.valueOf(entry.getValue()));
        if (byPlayer) {
            string = Formatter.command(String.format("statistics %s byType %s", isBlockEntity ? "block-entities" : "entities", entry.getKey()), (String)string);
        }
        return string;
    }

    private static String createHeader(boolean isBlockEntity, boolean byPlayer, boolean isPlayer, class_3222 player) {
        String title = player == null ? CommandConfig.STATS_PAGE_TITLE.get().replace("${type}", byPlayer ? "Player" : "Type") : CommandConfig.STATS_PAGE_TITLE_PLAYER.get().replace("${player}", player.method_5820());
        return Formatter.line(title.replace("${title}", isBlockEntity ? "Block Entities" : "Entities"), 40, isPlayer);
    }

    private static String createFooter(int page, int pageCount, boolean isBlockEntity, CommandContext<class_2168> context) {
        String title = CommandConfig.STATS_PAGE_FOOTER.get().replace("${page}", String.valueOf(page)).replace("${page_count}", String.valueOf(pageCount));
        Object command = context.getInput().replaceAll("\\b\\d+\\b", "%page_nr%");
        if (!((String)command).contains("%page_nr%")) {
            command = (String)command + " %page_nr%";
        }
        return Formatter.line(Formatter.page(title, (String)command, page), isBlockEntity ? 40 : 38, ((class_2168)context.getSource()).method_9228() instanceof class_3222);
    }
}

