/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.config.serialization.StringEntryReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class EntryCollectionBuilder<T>
extends StringEntryReader<T> {
    public static final String CONFIG_DESCRIPTION = "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported.";

    private EntryCollectionBuilder(class_2378<T> registry) {
        super(registry);
    }

    public Set<T> buildSet(List<String> locations) {
        return this.buildSet(locations, flag -> true, "");
    }

    public Map<T, double[]> buildMap(List<String> locations) {
        return this.buildMap(locations, (entry, value) -> true, "");
    }

    public Set<T> buildSet(List<String> locations, Predicate<T> condition, String errorMessage) {
        HashSet set = Sets.newHashSet();
        for (String source : locations) {
            this.getEntriesFromRegistry(source.trim()).forEach(entry -> {
                if (condition.test(entry)) {
                    if (this.isNotPresent(set, entry)) {
                        set.add(entry);
                    }
                } else {
                    EntryCollectionBuilder.log(source, errorMessage);
                }
            });
        }
        return set;
    }

    public Map<T, double[]> buildMap(List<String> locations, BiPredicate<T, double[]> condition, String errorMessage) {
        HashMap map = Maps.newHashMap();
        for (String source : locations) {
            String[] splitSource = (String[])Stream.of(source.split(",")).map(String::trim).toArray(String[]::new);
            if (splitSource.length == 0) {
                EntryCollectionBuilder.log(source, "Wrong number of arguments");
                continue;
            }
            List entries = this.getEntriesFromRegistry(splitSource[0]);
            if (entries.isEmpty()) continue;
            double[] values = Stream.of(splitSource).skip(1L).mapToDouble(value -> EntryCollectionBuilder.parseDouble(value, source)).toArray();
            for (Object entry : entries) {
                if (condition.test(entry, values)) {
                    if (!this.isNotPresent(map.keySet(), entry)) continue;
                    map.put(entry, values);
                    continue;
                }
                EntryCollectionBuilder.log(source, errorMessage);
            }
        }
        return map;
    }

    private static double parseDouble(String value, String source) {
        if (value.equalsIgnoreCase("true")) {
            return 1.0;
        }
        if (value.equalsIgnoreCase("false")) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ignored) {
            EntryCollectionBuilder.log(source, "Invalid number format");
            return 0.0;
        }
    }

    public static <T> EntryCollectionBuilder<T> of(class_2378<T> registry) {
        return new EntryCollectionBuilder<T>(registry);
    }

    public static String buildConfigDescription(String additionalData) {
        return String.format("Format for every entry is \"<namespace>:<path>%s\". Path may use asterisk as wildcard parameter. Tags are not supported.", additionalData);
    }

    @SafeVarargs
    public static <T> List<String> getKeyList(class_2378<T> registry, T ... entries) {
        return Stream.of(entries).map(arg_0 -> registry.method_10221(arg_0)).filter(Objects::nonNull).map(class_2960::toString).collect(Collectors.toList());
    }
}

