/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.onyxstudios.cca.api.v3.component.ComponentFactory;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.capability.data.CapabilityComponent;
import fuzs.puzzleslib.capability.data.PlayerRespawnStrategy;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class CapabilityController
implements EntityComponentInitializer {
    private static final Map<String, CapabilityController> MOD_TO_CAPABILITIES = Maps.newConcurrentMap();
    private final String namespace;
    private final Multimap<Class<?>, Consumer<Object>> typeToRegistration = ArrayListMultimap.create();

    @Deprecated
    public CapabilityController() {
        this("_internal");
    }

    private CapabilityController(String namespace) {
        this.namespace = namespace;
    }

    public <T extends class_1297, C extends CapabilityComponent> ComponentKey<C> registerEntityCapability(String capabilityKey, Class<C> capabilityType, ComponentFactory<T, C> capabilityFactory, Class<T> entityType) {
        return this.registerCapability(class_1297.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof EntityComponentFactoryRegistry) {
                EntityComponentFactoryRegistry registry = (EntityComponentFactoryRegistry)o;
                registry.registerFor(entityType, componentKey, capabilityFactory);
            }
        });
    }

    public <C extends CapabilityComponent> ComponentKey<C> registerPlayerCapability(String capabilityKey, Class<C> capabilityType, ComponentFactory<class_1657, C> capabilityFactory, PlayerRespawnStrategy respawnStrategy) {
        return this.registerCapability(class_1297.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof EntityComponentFactoryRegistry) {
                EntityComponentFactoryRegistry registry = (EntityComponentFactoryRegistry)o;
                registry.registerForPlayers(componentKey, capabilityFactory, respawnStrategy.toComponentStrategy());
            }
        });
    }

    private <C extends CapabilityComponent> ComponentKey<C> registerCapability(Class<?> objectType, String capabilityKey, Class<C> capabilityType, Function<ComponentKey<C>, Consumer<Object>> factoryRegistration) {
        ComponentKey componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(this.locate(capabilityKey), capabilityType);
        this.typeToRegistration.put(objectType, factoryRegistration.apply(componentKey));
        return componentKey;
    }

    private class_2960 locate(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new class_2960(this.namespace, path);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        CapabilityController.registerComponentFactories(class_1297.class, registry);
    }

    private static <T> void registerComponentFactories(Class<?> baseType, T registry) {
        for (CapabilityController controller : MOD_TO_CAPABILITIES.values()) {
            for (Consumer factoryRegistration : controller.typeToRegistration.get(baseType)) {
                factoryRegistration.accept(registry);
            }
        }
    }

    public static synchronized CapabilityController of(String namespace) {
        return MOD_TO_CAPABILITIES.computeIfAbsent(namespace, key -> {
            CapabilityController manager = new CapabilityController(namespace);
            PuzzlesLib.LOGGER.info("Creating capability controller for mod id {}", (Object)namespace);
            return manager;
        });
    }
}

