/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.enchanting;

import com.almostreliable.morejs.MoreJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuExtension;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuProcess;
import com.almostreliable.morejs.features.enchantment.EnchantmentState;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableChangedJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableIsEnchantableEventJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableServerEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1718.class})
public abstract class EnchantmentMenuMixin
extends class_1703
implements EnchantmentMenuExtension {
    @Unique
    private EnchantmentMenuProcess morejs$process;
    @Shadow
    @Final
    private Random field_7811;
    @Shadow
    @Final
    private class_1263 field_7809;
    @Shadow
    @Final
    private class_3914 field_7813;

    protected EnchantmentMenuMixin(@Nullable class_3917<?> menuType, int i) {
        super(menuType, i);
    }

    @Override
    public EnchantmentMenuProcess getMoreJSProcess() {
        return this.morejs$process;
    }

    @Override
    public class_1263 getMoreJsEnchantSlots() {
        return this.field_7809;
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    private void initializeProcess(int i, class_1661 inventory, class_3914 containerLevelAccess, CallbackInfo ci) {
        this.morejs$process = new EnchantmentMenuProcess((class_1718)this);
        this.morejs$process.setPlayer(inventory.field_7546);
    }

    @Inject(method={"slotsChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ContainerLevelAccess;execute(Ljava/util/function/BiConsumer;)V")}, cancellable=true)
    private void slotchanged$PrepareChangeEvent(class_1263 container, CallbackInfo ci) {
        this.field_7813.method_17393((level, pos) -> {
            class_1799 item = container.method_5438(0);
            if (this.morejs$process.matchesCurrentItem(item)) {
                ci.cancel();
                return;
            }
            this.morejs$process.prepareEvent(item);
            MoreJS.LOG.warn("<{}> Pre SlotChange: {}", (Object)this.morejs$process.getPlayer(), (Object)item);
        });
    }

    @Redirect(method={"slotsChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEnchantable()Z"))
    private boolean slotChanged$InvokeEnchantableEvent(class_1799 itemStack, class_1263 container) {
        Boolean[] result = new Boolean[1];
        this.field_7813.method_17393((level, pos) -> {
            class_1799 secondItem = container.method_5438(1);
            EnchantmentTableIsEnchantableEventJS e = new EnchantmentTableIsEnchantableEventJS(itemStack, secondItem, (class_1937)level, (class_2338)pos, this.morejs$process);
            e.post(ScriptType.SERVER, "morejs.enchantment_table.isEnchantable");
            result[0] = e.getIsEnchantable();
        });
        return this.morejs$process.storeItemIsEnchantable(result[0], itemStack);
    }

    @Inject(method={"slotsChanged"}, at={@At(value="RETURN")})
    private void slotChanged$InvokeChangeEvent(class_1263 container, CallbackInfo ci) {
        if (container != this.field_7809 || !this.morejs$process.isFreezeBroadcast()) {
            return;
        }
        class_1799 item = container.method_5438(0);
        this.field_7813.method_17393((level, pos) -> {
            class_1799 secondItem = container.method_5438(1);
            this.morejs$process.setFreezeBroadcast(false);
            this.morejs$process.setState(EnchantmentState.USE_STORED_ENCHANTMENTS);
            MoreJS.LOG.warn("<{}> Post SlotChange: {}", (Object)this.morejs$process.getPlayer(), (Object)item);
            new EnchantmentTableChangedJS(item, secondItem, (class_1937)level, (class_2338)pos, this.morejs$process, this.field_7811).post(ScriptType.SERVER, "morejs.enchantment_table.changed");
        });
        if (item.method_7960() || !this.morejs$process.isItemEnchantable(item)) {
            this.morejs$process.clearEnchantments();
        }
    }

    @Inject(method={"getEnchantmentList"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleEnchantmentGetter(class_1799 itemStack, int index, int powerLevel, CallbackInfoReturnable<List<class_1889>> cir) {
        switch (this.morejs$process.getState()) {
            case STORE_ENCHANTMENTS: {
                this.morejs$process.setEnchantments(index, (List)cir.getReturnValue());
                break;
            }
            case USE_STORED_ENCHANTMENTS: {
                List<class_1889> enchantments = this.morejs$process.getEnchantments(index);
                if (enchantments == null) {
                    MoreJS.LOG.error("Enchantment list is null for index " + index + ", when in state USE_STORED_ENCHANTMENTS");
                    return;
                }
                cir.setReturnValue(enchantments);
            }
        }
    }

    @Inject(method={"clickMenuButton"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ContainerLevelAccess;execute(Ljava/util/function/BiConsumer;)V")}, cancellable=true)
    private void clickMenuButton$InvokeEnchantEvent(class_1657 player, int i, CallbackInfoReturnable<Boolean> cir) {
        this.field_7813.method_17393((level, pos) -> {
            if (player != this.morejs$process.getPlayer()) {
                MoreJS.LOG.warn("<{}> Player changed during clickMenuButton", (Object)this.morejs$process.getPlayer());
                return;
            }
            class_1799 item = this.field_7809.method_5438(0);
            class_1799 secondItem = this.field_7809.method_5438(1);
            EnchantmentTableServerEventJS e = new EnchantmentTableServerEventJS(item, secondItem, (class_1937)level, (class_2338)pos, player, this.morejs$process, true);
            e.post(ScriptType.SERVER, "morejs.enchantment_table.enchant");
            if (e.isCancelled()) {
                cir.setReturnValue((Object)false);
            }
            if (e.itemWasChanged()) {
                cir.setReturnValue((Object)false);
                class_1799 newItem = e.getItem().getItemStack().method_7972();
                this.morejs$process.abortEvent(newItem);
                this.field_7809.method_5447(0, newItem);
            }
        });
    }

    public void method_7623() {
        if (this.morejs$process.isFreezeBroadcast()) {
            MoreJS.LOG.warn("<{}> Freezing broadcast", (Object)this.morejs$process.getPlayer());
            return;
        }
        super.method_7623();
    }
}

