/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.trades.MapPosInfo;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.almostreliable.morejs.util.LevelUtils;
import com.almostreliable.morejs.util.ResourceOrTag;
import com.almostreliable.morejs.util.WeightedList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class TreasureMapTrade
extends TransformableTrade<TreasureMapTrade> {
    protected final MapPosInfo.Provider destinationPositionFunc;
    @Nullable
    protected class_2561 displayName;
    protected class_20.class_21 destinationType = class_20.class_21.field_110;
    private boolean renderBiomePreviewMap = true;
    private byte mapViewScale = (byte)2;

    public TreasureMapTrade(class_1799[] inputs, MapPosInfo.Provider destinationPositionFunc) {
        super(inputs);
        this.destinationPositionFunc = destinationPositionFunc;
    }

    public static TreasureMapTrade forStructure(class_1799[] input, WeightedList<Object> entries) {
        WeightedList<ResourceOrTag> list = entries.map(o -> {
            if (o == null) {
                return null;
            }
            return ResourceOrTag.get(o.toString(), class_2378.field_25915);
        });
        MapPosInfo.Provider func = (level, entity) -> {
            ResourceOrTag roll = (ResourceOrTag)list.roll(level.field_9229);
            class_2338 pos = LevelUtils.findStructure(entity.method_24515(), level, roll, 100);
            if (pos == null) {
                return null;
            }
            return new MapPosInfo(pos, roll.getName());
        };
        return new TreasureMapTrade(input, func);
    }

    public static TreasureMapTrade forBiome(class_1799[] input, WeightedList<Object> entries) {
        WeightedList<ResourceOrTag> list = entries.map(o -> {
            if (o == null) {
                return null;
            }
            return ResourceOrTag.get(o.toString(), class_2378.field_25114);
        });
        MapPosInfo.Provider func = (level, entity) -> {
            ResourceOrTag roll = (ResourceOrTag)list.roll(level.field_9229);
            class_2338 pos = LevelUtils.findBiome(entity.method_24515(), level, roll, 250);
            if (pos == null) {
                return null;
            }
            return new MapPosInfo(pos, roll.getName());
        };
        return new TreasureMapTrade(input, func);
    }

    public TreasureMapTrade displayName(class_2561 name) {
        this.displayName = name;
        return this;
    }

    public TreasureMapTrade marker(class_20.class_21 type) {
        this.destinationType = type;
        return this;
    }

    public TreasureMapTrade noPreview() {
        this.renderBiomePreviewMap = false;
        return this;
    }

    public TreasureMapTrade scale(byte scale) {
        this.mapViewScale = scale;
        return this;
    }

    @Override
    @Nullable
    public class_1914 createOffer(class_1297 trader, Random rand) {
        class_1937 class_19372 = trader.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            MapPosInfo info = this.destinationPositionFunc.apply(level, trader);
            if (info == null) {
                return null;
            }
            class_1799 map = class_1806.method_8005((class_1937)level, (int)info.pos().method_10263(), (int)info.pos().method_10260(), (byte)this.mapViewScale, (boolean)true, (boolean)true);
            if (this.renderBiomePreviewMap) {
                class_1806.method_8002((class_3218)level, (class_1799)map);
            }
            class_22.method_110((class_1799)map, (class_2338)info.pos(), (String)"+", (class_20.class_21)this.destinationType);
            map.method_7977(this.displayName == null ? info.name() : this.displayName);
            return this.createOffer(map);
        }
        return null;
    }
}

