/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.EnchantedItemTrade;
import com.almostreliable.morejs.features.villager.trades.MapPosInfo;
import com.almostreliable.morejs.features.villager.trades.PotionTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.StewTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.almostreliable.morejs.features.villager.trades.TreasureMapTrade;
import com.almostreliable.morejs.util.WeightedList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class VillagerUtils {
    public static final Set<Class<? extends class_3853.class_1652>> VANILLA_TRADE_TYPES = Set.of(class_3853.class_4160.class, class_3853.class_1648.class, class_3853.class_4163.class, class_3853.class_4165.class, class_3853.class_4164.class, class_3853.class_4161.class, class_3853.class_4167.class, class_3853.class_4166.class, class_3853.class_1654.class);

    public static boolean isVanillaTrade(class_3853.class_1652 listing) {
        return VANILLA_TRADE_TYPES.contains(listing.getClass());
    }

    public static boolean isModdedTrade(class_3853.class_1652 listing) {
        return !VillagerUtils.isVanillaTrade(listing) && !VillagerUtils.isMoreJSTrade(listing);
    }

    public static boolean isMoreJSTrade(class_3853.class_1652 listing) {
        return listing instanceof TransformableTrade || listing instanceof CustomTrade;
    }

    public static Collection<class_3852> getProfessions() {
        return class_2378.field_17167.method_10220().filter(p -> !p.method_35202().equals("none")).toList();
    }

    public static SimpleTrade createSimpleTrade(class_1799[] inputs, class_1799 output) {
        return new SimpleTrade(inputs, output);
    }

    public static CustomTrade createCustomTrade(TransformableTrade.Transformer transformer) {
        return new CustomTrade(transformer);
    }

    public static TreasureMapTrade createStructureMapTrade(class_1799[] inputs, WeightedList<Object> structures) {
        return TreasureMapTrade.forStructure(inputs, structures);
    }

    public static TreasureMapTrade createBiomeMapTrade(class_1799[] inputs, WeightedList<Object> biomes) {
        return TreasureMapTrade.forBiome(inputs, biomes);
    }

    public static TreasureMapTrade createCustomMapTrade(class_1799[] inputs, MapPosInfo.Provider func) {
        return new TreasureMapTrade(inputs, func);
    }

    public static EnchantedItemTrade createEnchantedItemTrade(class_1799[] inputs, class_1792 output) {
        return new EnchantedItemTrade(inputs, output);
    }

    public static StewTrade createStewTrade(class_1799[] inputs, class_1291[] effects, int duration) {
        return new StewTrade(inputs, effects, duration);
    }

    public static PotionTrade createPotionTrade(class_1799[] inputs) {
        return new PotionTrade(inputs);
    }
}

