/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.events.VillagerTradingEventJS;
import com.almostreliable.morejs.features.villager.events.WandererTradingEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class TradingManager {
    @Nullable
    protected Map<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> tradesBackup;
    @Nullable
    protected Int2ObjectMap<List<class_3853.class_1652>> wandererTradesBackup;

    public void invokeVillagerTradeEvent(Map<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> originalTrades) {
        this.updateVanillaTrades(originalTrades);
        Map<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> trades = this.createMutableTradesMapByProfessions();
        new VillagerTradingEventJS(trades).post(ScriptType.SERVER, "morejs.villager.trades");
        this.updateVanillaTrades(trades);
    }

    public void invokeWanderingTradeEvent(Int2ObjectMap<List<class_3853.class_1652>> originalTrades) {
        this.updateVanillaWanderingTrades(originalTrades);
        Int2ObjectMap<List<class_3853.class_1652>> wandererTrades = this.toListingsListMap((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724);
        new WandererTradingEventJS(wandererTrades).post(ScriptType.SERVER, "morejs.wanderer.trades");
        this.updateVanillaWanderingTrades(wandererTrades);
    }

    public void reload() {
        this.invokeVillagerTradeEvent(this.getTradesBackup());
        this.invokeWanderingTradeEvent(this.getWandererTradesBackup());
    }

    public Map<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> getTradesBackup() {
        if (this.tradesBackup == null) {
            this.tradesBackup = this.createMutableTradesMapByProfessions();
        }
        return this.tradesBackup;
    }

    public Int2ObjectMap<List<class_3853.class_1652>> getWandererTradesBackup() {
        if (this.wandererTradesBackup == null) {
            this.wandererTradesBackup = this.toListingsListMap((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724);
        }
        return this.wandererTradesBackup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> createMutableTradesMapByProfessions() {
        Map map = class_3853.field_17067;
        synchronized (map) {
            HashMap<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> result = new HashMap<class_3852, Int2ObjectMap<List<class_3853.class_1652>>>();
            class_3853.field_17067.forEach((profession, trades) -> {
                Int2ObjectMap<List<class_3853.class_1652>> map = this.toListingsListMap((Int2ObjectMap<class_3853.class_1652[]>)trades);
                result.put((class_3852)profession, map);
            });
            return result;
        }
    }

    private synchronized Int2ObjectMap<List<class_3853.class_1652>> toListingsListMap(Int2ObjectMap<class_3853.class_1652[]> listingsMap) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        listingsMap.forEach((level, listings) -> {
            ArrayList<class_3853.class_1652> newListings = new ArrayList<class_3853.class_1652>(Arrays.stream(listings).toList());
            result.put(level.intValue(), newListings);
        });
        return result;
    }

    private synchronized Int2ObjectMap<class_3853.class_1652[]> toListingsArrayMap(Int2ObjectMap<List<class_3853.class_1652>> listingsMap) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        listingsMap.forEach((level, listings) -> result.put(level.intValue(), (Object)listings.toArray(new class_3853.class_1652[0])));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVanillaTrades(Map<class_3852, Int2ObjectMap<List<class_3853.class_1652>>> trades) {
        Map map = class_3853.field_17067;
        synchronized (map) {
            class_3853.field_17067.clear();
            trades.forEach((profession, newTrades) -> {
                Int2ObjectMap<class_3853.class_1652[]> vanillaTrades = this.toListingsArrayMap((Int2ObjectMap<List<class_3853.class_1652>>)newTrades);
                class_3853.field_17067.put(profession, vanillaTrades);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVanillaWanderingTrades(Int2ObjectMap<List<class_3853.class_1652>> trades) {
        Int2ObjectMap int2ObjectMap = class_3853.field_17724;
        synchronized (int2ObjectMap) {
            class_3853.field_17724.clear();
            Int2ObjectMap<class_3853.class_1652[]> map = this.toListingsArrayMap(trades);
            class_3853.field_17724.putAll(map);
        }
    }
}

