/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.structure;

import com.almostreliable.morejs.features.structure.StructureBlockInfoModification;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3499;

public class PaletteWrapper {
    private final class_3499.class_5162 palette;
    private final class_2382 borderSize;
    private final Map<class_2338, class_3499.class_3501> cache = new HashMap<class_2338, class_3499.class_3501>();

    public PaletteWrapper(class_3499.class_5162 palette, class_2382 borderSize) {
        this.palette = palette;
        this.borderSize = borderSize;
    }

    public void clear() {
        this.palette.method_27125().clear();
        this.cache.clear();
    }

    public void add(class_2338 pos, class_2680 state) {
        this.add(pos, state, null);
    }

    public void add(class_2338 pos, class_2680 state, @Nullable class_2487 tag) {
        Preconditions.checkNotNull((Object)pos, (Object)"Invalid position");
        Preconditions.checkNotNull((Object)state, (Object)"Invalid state");
        Preconditions.checkArgument((0 <= pos.method_10263() && pos.method_10263() < this.borderSize.method_10263() ? 1 : 0) != 0, (Object)("Invalid position, x must be between 0 and " + this.borderSize.method_10263()));
        Preconditions.checkArgument((0 <= pos.method_10263() && pos.method_10264() < this.borderSize.method_10264() ? 1 : 0) != 0, (Object)("Invalid position, y must be between 0 and " + this.borderSize.method_10264()));
        Preconditions.checkArgument((0 <= pos.method_10263() && pos.method_10260() < this.borderSize.method_10260() ? 1 : 0) != 0, (Object)("Invalid position, z must be between 0 and " + this.borderSize.method_10260()));
        class_3499.class_3501 info = this.get(pos);
        if (info instanceof StructureBlockInfoModification) {
            StructureBlockInfoModification mod = (StructureBlockInfoModification)info;
            mod.setVanillaBlockState(state);
            mod.setNbt(tag);
            return;
        }
        class_3499.class_3501 newInfo = new class_3499.class_3501(pos, state, tag);
        this.palette.method_27125().add(newInfo);
        this.cache.put(pos, newInfo);
    }

    public void forEach(Consumer<class_3499.class_3501> consumer) {
        this.palette.method_27125().forEach(consumer);
    }

    public void removeIf(Predicate<class_3499.class_3501> predicate) {
        this.palette.method_27125().removeIf((? super E block) -> {
            if (predicate.test((class_3499.class_3501)block)) {
                this.cache.remove(block.field_15597);
                return true;
            }
            return false;
        });
    }

    @Nullable
    public class_3499.class_3501 get(class_2338 pos) {
        if (this.cache.isEmpty()) {
            this.forEach(info -> this.cache.put(info.field_15597, (class_3499.class_3501)info));
        }
        return this.cache.get(pos);
    }
}

