/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.mixin.potion.PotionBrewingAccessor;
import com.almostreliable.morejs.util.Utils;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import javax.annotation.Nullable;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import org.apache.commons.lang3.StringUtils;

public abstract class PotionBrewingRegisterEvent
extends EventJS {
    protected void validate(IngredientJS topInput, IngredientJS bottomInput, ItemStackJS output) {
        Preconditions.checkArgument((!topInput.isEmpty() ? 1 : 0) != 0, (Object)"Top input must have at least one item");
        Preconditions.checkArgument((!bottomInput.isEmpty() ? 1 : 0) != 0, (Object)"Bottom input must have at least one item");
        Preconditions.checkArgument((!output.isEmpty() ? 1 : 0) != 0, (Object)"Output must not be empty");
    }

    protected void validateSimple(class_1842 from, IngredientJS ingredient, class_1842 to) {
        Preconditions.checkNotNull((Object)from, (Object)"Input potion must not be null");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkNotNull((Object)to, (Object)"Output potion must not be null");
        Preconditions.checkArgument((!ingredient.isEmpty() ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
    }

    public abstract void addCustomBrewing(IngredientJS var1, IngredientJS var2, ItemStackJS var3);

    public abstract void addPotionBrewing(IngredientJS var1, class_1842 var2, class_1842 var3);

    public void addPotionBrewing(IngredientJS ingredient, class_1842 output) {
        this.addPotionBrewing(ingredient, class_1847.field_8991, output);
    }

    public void removeByPotion(@Nullable class_1842 input, @Nullable IngredientJS ingredient, @Nullable class_1842 output) {
        class_1856 vanillaIngredient = ingredient == null ? null : ingredient.createVanillaIngredient();
        PotionBrewingAccessor.getMixes().removeIf(mix -> {
            boolean matches;
            boolean matchesInput = input == null || this.getInputPotionFromMix((class_1845.class_1846<class_1842>)mix) == input;
            boolean matchesIngredient = vanillaIngredient == null || Utils.matchesIngredient(vanillaIngredient, mix.field_8960);
            boolean matchesOutput = output == null || this.getOutputPotionFromMix((class_1845.class_1846<class_1842>)mix) == output;
            boolean bl = matches = matchesInput && matchesIngredient && matchesOutput;
            if (matches) {
                ConsoleJS.STARTUP.info((Object)("Removed potion brewing recipe: " + class_2378.field_11143.method_10221((Object)this.getInputPotionFromMix((class_1845.class_1846<class_1842>)mix)) + " + " + StringUtils.abbreviate((String)mix.field_8960.method_8089().toString(), (int)64) + " -> " + class_2378.field_11143.method_10221((Object)this.getOutputPotionFromMix((class_1845.class_1846<class_1842>)mix))));
            }
            return matches;
        });
    }

    protected abstract class_1842 getInputPotionFromMix(class_1845.class_1846<class_1842> var1);

    protected abstract class_1842 getOutputPotionFromMix(class_1845.class_1846<class_1842> var1);
}

