/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.MoreJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentState;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1889;

public class EnchantmentMenuProcess {
    private final class_1718 menu;
    private final Int2ObjectOpenHashMap<List<class_1889>> enchantments = new Int2ObjectOpenHashMap();
    private boolean freezeBroadcast = false;
    private class_1799 currentItem = class_1799.field_8037;
    private Boolean itemIsEnchantable = null;
    private EnchantmentState state = EnchantmentState.IDLE;
    private class_1657 player;

    public EnchantmentMenuProcess(class_1718 menu) {
        this.menu = menu;
    }

    public boolean isFreezeBroadcast() {
        return this.freezeBroadcast;
    }

    public void setFreezeBroadcast(boolean freezeBroadcast) {
        this.freezeBroadcast = freezeBroadcast;
    }

    public boolean matchesCurrentItem(class_1799 item) {
        return !this.currentItem.method_7960() && class_1799.method_7973((class_1799)this.currentItem, (class_1799)item);
    }

    public void setCurrentItem(class_1799 currentItem) {
        this.currentItem = currentItem;
        if (currentItem.method_7960()) {
            this.itemIsEnchantable = null;
        }
    }

    public void clearEnchantments() {
        MoreJS.LOG.warn("<{}> Clearing enchantments", (Object)this.player);
        this.enchantments.clear();
    }

    public boolean storeItemIsEnchantable(@Nullable Boolean override, class_1799 item) {
        this.itemIsEnchantable = override != null ? override.booleanValue() : item.method_7923();
        return this.itemIsEnchantable;
    }

    public boolean isItemEnchantable(class_1799 item) {
        return this.itemIsEnchantable == null ? item.method_7923() : this.itemIsEnchantable.booleanValue();
    }

    public void setEnchantments(int index, List<class_1889> enchantments) {
        String s = this.formatEnchantments(enchantments);
        MoreJS.LOG.info("<{}> Setting enchantments for index {} [{}]", (Object)this.player, (Object)index, (Object)s);
        this.enchantments.put(index, new ArrayList<class_1889>(enchantments));
    }

    private String formatEnchantments(List<class_1889> enchantments) {
        return enchantments.stream().map(i -> i.field_9093.method_8179(i.field_9094).toString()).collect(Collectors.joining(","));
    }

    public List<class_1889> getEnchantments(int index) {
        return (List)this.enchantments.computeIfAbsent(index, $ -> new ArrayList());
    }

    public EnchantmentState getState() {
        return this.state;
    }

    public void setState(EnchantmentState storeEnchantments) {
        MoreJS.LOG.warn("<{}> State: {}", (Object)this.player, (Object)storeEnchantments);
        this.state = storeEnchantments;
    }

    public class_1718 getMenu() {
        return this.menu;
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public void setPlayer(class_1657 player) {
        this.player = player;
    }

    public void prepareEvent(class_1799 item) {
        this.setCurrentItem(item);
        this.clearEnchantments();
        this.setFreezeBroadcast(true);
        this.setState(EnchantmentState.STORE_ENCHANTMENTS);
    }

    public void abortEvent(class_1799 item) {
        this.setCurrentItem(item);
        this.clearEnchantments();
        this.setState(EnchantmentState.IDLE);
    }
}

