/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractConfigEntry<T>
extends DynamicElementListWidget.ElementEntry<AbstractConfigEntry<T>>
implements ReferenceProvider<T> {
    private AbstractConfigScreen screen;
    private Supplier<Optional<class_2561>> errorSupplier;
    @Nullable
    private List<ReferenceProvider<?>> referencableEntries = null;

    public final void setReferenceProviderEntries(@Nullable List<ReferenceProvider<?>> referencableEntries) {
        this.referencableEntries = referencableEntries;
    }

    public void requestReferenceRebuilding() {
        AbstractConfigScreen configScreen = this.getConfigScreen();
        if (configScreen instanceof ReferenceBuildingConfigScreen) {
            ((ReferenceBuildingConfigScreen)((Object)configScreen)).requestReferenceRebuilding();
        }
    }

    @Override
    @NotNull
    public AbstractConfigEntry<T> provideReferenceEntry() {
        return this;
    }

    @Nullable
    @ApiStatus.Internal
    public final List<ReferenceProvider<?>> getReferenceProviderEntries() {
        return this.referencableEntries;
    }

    public abstract boolean isRequiresRestart();

    public abstract void setRequiresRestart(boolean var1);

    public abstract class_2561 getFieldName();

    public class_2561 getDisplayedFieldName() {
        class_5250 text = this.getFieldName().method_27661();
        boolean hasError = this.getConfigError().isPresent();
        boolean isEdited = this.isEdited();
        if (hasError) {
            text = text.method_27692(class_124.field_1061);
        }
        if (isEdited) {
            text = text.method_27692(class_124.field_1056);
        }
        if (!hasError && !isEdited) {
            text = text.method_27692(class_124.field_1080);
        }
        return text;
    }

    public abstract T getValue();

    public final Optional<class_2561> getConfigError() {
        if (this.errorSupplier != null && this.errorSupplier.get().isPresent()) {
            return this.errorSupplier.get();
        }
        return this.getError();
    }

    public void lateRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    public void setErrorSupplier(Supplier<Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    public Optional<class_2561> getError() {
        return Optional.empty();
    }

    public abstract Optional<T> getDefaultValue();

    @Nullable
    public final AbstractConfigScreen getConfigScreen() {
        return this.screen;
    }

    public final void addTooltip(@NotNull Tooltip tooltip) {
        this.screen.addTooltip(tooltip);
    }

    public void updateSelected(boolean isSelected) {
    }

    @ApiStatus.Internal
    public final void setScreen(AbstractConfigScreen screen) {
        this.screen = screen;
    }

    public abstract void save();

    public boolean isEdited() {
        return this.getConfigError().isPresent();
    }

    @Override
    public int getItemHeight() {
        return 24;
    }

    public int getInitialReferenceOffset() {
        return 0;
    }
}

