/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ToggleEditingModeMessage() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleEditingModeMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("toggle_editing_mode_message"));
    public static final ToggleEditingModeMessage INSTANCE = new ToggleEditingModeMessage();
    public static final StreamCodec<FriendlyByteBuf, ToggleEditingModeMessage> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<ToggleEditingModeMessage> type() {
        return TYPE;
    }

    public static void handle(ToggleEditingModeMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (PermissionsHelper.hasEditorPermission(player, false) || player.getServer() != null && player.getServer().isSingleplayerOwner(player.getGameProfile())) {
                ServerQuestFile.INSTANCE.getTeamData((Player)player).ifPresent(data -> data.setCanEdit((Player)player, !data.getCanEdit((Player)player)));
            }
        });
    }
}

