/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity.ai;

import com.tristankechlo.livingthings.entity.PeacockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class PeacockDestroyCropBlocks
extends MoveToBlockGoal {
    private final PeacockEntity peacock;
    private boolean reachedTarget = false;

    public PeacockDestroyCropBlocks(PeacockEntity entity) {
        super((PathfinderMob)entity, 1.0, 16);
        this.peacock = entity;
    }

    public void tick() {
        BlockPos targetPos = this.getMoveToTarget();
        if (!targetPos.closerToCenterThan((Position)this.mob.position(), this.acceptedDistance())) {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.moveMobToBlock();
            }
        } else {
            this.reachedTarget = true;
            --this.tryTicks;
        }
        if (!this.isReachedTarget()) {
            return;
        }
        this.peacock.setDestroyingCrops(true);
        if (this.peacock.getRandom().nextInt(100) == 0) {
            this.peacock.level().destroyBlock(targetPos, false);
            this.peacock.startFluffing();
        }
    }

    protected BlockPos getMoveToTarget() {
        return this.blockPos;
    }

    protected void moveMobToBlock() {
        BlockPos blockpos = this.getMoveToTarget();
        Path path = this.mob.getNavigation().createPath((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, 0);
        this.mob.getNavigation().moveTo(path, this.speedModifier);
    }

    public double acceptedDistance() {
        return 0.75;
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof CropBlock) {
            CropBlock block = (CropBlock)state.getBlock();
            return block.isMaxAge(state);
        }
        return false;
    }

    public boolean isReachedTarget() {
        return this.reachedTarget;
    }

    public void stop() {
        super.stop();
        this.peacock.setDestroyingCrops(false);
    }
}

