/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.SeahorseConfig;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class SeahorseEntity
extends AbstractSchoolingFish
implements IMobVariants,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public SeahorseEntity(EntityType<SeahorseEntity> type, Level world) {
        super(type, world);
    }

    public static boolean checkSeahorseSpawnRules(EntityType<SeahorseEntity> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getFluidState(pos).is(LivingThingsTags.SEAHORSE_SPAWNABLE_ON) && world.getFluidState(pos.above()).is(LivingThingsTags.SEAHORSE_SPAWNABLE_ON);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, SeahorseConfig.health()).add(Attributes.MOVEMENT_SPEED, SeahorseConfig.movementSpeed());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("SeahorseVariant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getByte("SeahorseVariant"));
    }

    protected SoundEvent getFlopSound() {
        return ModSounds.SEAHORSE_FLOP.get();
    }

    public int getMaxSpawnClusterSize() {
        return SeahorseConfig.maxSpawnedInChunk();
    }

    @Override
    public byte getVariant() {
        return (Byte)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.entityData.set(VARIANT, (Object)((byte)Mth.clamp((int)variant, (int)0, (int)4)));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.SEAHORSE_BUCKET.get());
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> tag.putInt("BucketSeahorseVariantTag", (int)this.getVariant()));
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.SEAHORSE;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData) {
        entityData = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        byte variant = 0;
        if (entityData instanceof SeahorseData) {
            variant = ((SeahorseData)((Object)entityData)).variant;
            entityData = new SeahorseData(this, variant);
        } else {
            int blueWeight = (Integer)SeahorseConfig.get().colorBlueWeight.get();
            int greenWeight = (Integer)SeahorseConfig.get().colorGreenWeight.get();
            int purpleWeight = (Integer)SeahorseConfig.get().colorPurpleWeight.get();
            int yellowWeight = (Integer)SeahorseConfig.get().colorYellowWeight.get();
            int redWeight = (Integer)SeahorseConfig.get().colorRedWeight.get();
            variant = this.getRandomVariant(this.random, new byte[]{0, 1, 2, 3, 4}, new int[]{blueWeight, greenWeight, purpleWeight, yellowWeight, redWeight});
        }
        this.setVariant(variant);
        return entityData;
    }

    private static final class SeahorseData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        private final byte variant;

        public SeahorseData(AbstractSchoolingFish fish, byte variant) {
            super(fish);
            this.variant = variant;
        }
    }
}

