/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class SeahorseConfig
extends EntityConfig {
    private static final SeahorseConfig INSTANCE = new SeahorseConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 4.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.2, 0.05, 10.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 6, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", SeahorseConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);
    public final NumberValue.IntegerValue colorRedWeight = new NumberValue.IntegerValue("colorRedWeight", 20, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorBlueWeight = new NumberValue.IntegerValue("colorBlueWeight", 20, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorGreenWeight = new NumberValue.IntegerValue("colorGreenWeight", 20, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorYellowWeight = new NumberValue.IntegerValue("colorYellowWeight", 20, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorPurpleWeight = new NumberValue.IntegerValue("colorPurpleWeight", 20, 0, Integer.MAX_VALUE);

    private SeahorseConfig() {
        super("seahorse");
        this.registerConfigValues(this.health, this.movementSpeed, this.maxSpawnedInChunk, this.spawnBiomes);
        this.registerForCategory("colorWeights", this.colorRedWeight, this.colorBlueWeight, this.colorGreenWeight, this.colorYellowWeight, this.colorPurpleWeight);
    }

    public static SeahorseConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)SeahorseConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)SeahorseConfig.INSTANCE.movementSpeed.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)SeahorseConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(19, 4, 7, new ResourceKey[]{Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN}));
    }
}

