/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class KoalaConfig
extends EntityConfig {
    private static final KoalaConfig INSTANCE = new KoalaConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 32767.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.17, 0.05, 10.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 5, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", KoalaConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private KoalaConfig() {
        super("koala");
        this.registerConfigValues(this.health, this.movementSpeed, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static KoalaConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)KoalaConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)KoalaConfig.INSTANCE.movementSpeed.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)KoalaConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(50, 3, 8, new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE}), new SpawnData(25, 3, 8, new ResourceKey[]{Biomes.BAMBOO_JUNGLE}), new SpawnData(10, 3, 8, new ResourceKey[]{Biomes.SAVANNA_PLATEAU}));
    }
}

