/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.elements.ElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.Alignment;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.ElementCategory;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.HorizontalAlignment;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.VerticalAlignment;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.BookRoot;

public abstract class ExtendedElementBuilder<T extends ExtendedElementBuilder<T>>
extends ElementBuilder {
    private final String type;
    private Integer x = null;
    private Integer y = null;
    private Integer z = null;
    private Integer w = null;
    private Integer h = null;
    private Float baseline = null;
    private Alignment align = null;
    private HorizontalAlignment horAlign = null;
    private VerticalAlignment vertAlign = null;
    private Integer indent = null;
    private Integer space = null;
    private String color = null;
    private Boolean bold = null;
    private Boolean italics = null;
    private Boolean underline = null;
    private Boolean strikethrough = null;
    private Boolean obfuscated = null;
    private ResourceLocation font = null;
    private Float scale = null;
    private String condition = null;

    protected ExtendedElementBuilder(ElementCategory elemCat, String type) {
        super(elemCat);
        this.type = type;
    }

    public final T posX(int x) {
        this.x = x;
        return (T)this;
    }

    public final T posY(int y) {
        this.y = y;
        return (T)this;
    }

    public final T posZ(int z) {
        this.z = z;
        return (T)this;
    }

    public final T width(int w) {
        this.w = w;
        return (T)this;
    }

    public final T height(int h) {
        this.h = h;
        return (T)this;
    }

    public final T baseline(float baseline) {
        this.baseline = Float.valueOf(baseline);
        return (T)this;
    }

    public final T align(Alignment align) {
        this.align = align;
        return (T)this;
    }

    public final T horAlign(HorizontalAlignment align) {
        this.horAlign = align;
        return (T)this;
    }

    public final T vertAlign(VerticalAlignment align) {
        this.vertAlign = align;
        return (T)this;
    }

    public final T indent(int indent) {
        this.indent = indent;
        return (T)this;
    }

    public final T space(int space) {
        this.space = space;
        return (T)this;
    }

    public final T color(String hexColor) {
        this.color = hexColor;
        return (T)this;
    }

    public final T bold(boolean bold) {
        this.bold = bold;
        return (T)this;
    }

    public final T italics(boolean italics) {
        this.italics = italics;
        return (T)this;
    }

    public final T underline(boolean underline) {
        this.underline = underline;
        return (T)this;
    }

    public final T strikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
        return (T)this;
    }

    public final T obfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
        return (T)this;
    }

    public final T font(ResourceLocation font) {
        this.font = font;
        return (T)this;
    }

    public final T scale(float scale) {
        this.scale = Float.valueOf(scale);
        return (T)this;
    }

    public final T condition(String condition) {
        this.condition = condition;
        return (T)this;
    }

    @Override
    public void validate(BookRoot book) {
        if (this.condition != null && !book.hasCondition(this.condition)) {
            throw new IllegalArgumentException("Unknown condition: " + this.condition);
        }
    }

    @Override
    public final void print(Document doc, Element parentElem) {
        Element elementElem = doc.createElement(this.type);
        ExtendedElementBuilder.printNullableAttr(elementElem, "x", this.x);
        ExtendedElementBuilder.printNullableAttr(elementElem, "y", this.y);
        ExtendedElementBuilder.printNullableAttr(elementElem, "z", this.z);
        ExtendedElementBuilder.printNullableAttr(elementElem, "w", this.w);
        ExtendedElementBuilder.printNullableAttr(elementElem, "h", this.h);
        ExtendedElementBuilder.printNullableAttr(elementElem, "baseline", this.baseline);
        ExtendedElementBuilder.printNullableAttr(elementElem, "align", this.horAlign != null ? this.horAlign : this.align);
        ExtendedElementBuilder.printNullableAttr(elementElem, "vertical-align", this.vertAlign);
        ExtendedElementBuilder.printNullableAttr(elementElem, "indent", this.indent);
        ExtendedElementBuilder.printNullableAttr(elementElem, "space", this.space);
        ExtendedElementBuilder.printNullableAttr(elementElem, "color", this.color);
        ExtendedElementBuilder.printNullableAttr(elementElem, "bold", this.bold);
        ExtendedElementBuilder.printNullableAttr(elementElem, "italics", this.italics);
        ExtendedElementBuilder.printNullableAttr(elementElem, "underline", this.underline);
        ExtendedElementBuilder.printNullableAttr(elementElem, "strikethrough", this.strikethrough);
        ExtendedElementBuilder.printNullableAttr(elementElem, "obfuscated", this.obfuscated);
        ExtendedElementBuilder.printNullableAttr(elementElem, "font", this.font);
        ExtendedElementBuilder.printNullableAttr(elementElem, "scale", this.scale);
        ExtendedElementBuilder.printNullableAttr(elementElem, "condition", this.condition);
        this.printInternal(doc, elementElem);
        parentElem.appendChild(elementElem);
    }

    protected static <T> void printNullableAttr(Element elem, String attr, T value) {
        ExtendedElementBuilder.printNullableAttr(elem, attr, value, Object::toString);
    }

    protected static <T> void printNullableAttr(Element elem, String attr, T value, Function<T, String> stringifier) {
        if (value != null) {
            elem.setAttribute(attr, stringifier.apply(value));
        }
    }

    protected abstract void printInternal(Document var1, Element var2);
}

