/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.ElevatedInnerPrismSkipPredicate;

@CullTest(value={BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM})
public final class ElevatedInnerSlopedPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        Direction orientation = cmpDir.orientation();
        if (side != orientation || orientation.getAxis() == cmpDir.direction().getAxis()) {
            return false;
        }
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM -> ElevatedInnerSlopedPrismSkipPredicate.testAgainstInnerSlopedPrism(cmpDir, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_PRISM -> ElevatedInnerSlopedPrismSkipPredicate.testAgainstInnerPrism(cmpDir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_SLOPED_PRISM})
    private static boolean testAgainstInnerSlopedPrism(CompoundDirection cmpDir, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.getValue(PropertyHolder.FACING_DIR));
        return ElevatedInnerSlopedPrismSkipPredicate.getTriDir(cmpDir, side).isEqualTo(ElevatedInnerSlopedPrismSkipPredicate.getTriDir(adjCmpDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_PRISM})
    private static boolean testAgainstInnerPrism(CompoundDirection cmpDir, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.getValue(PropertyHolder.FACING_AXIS));
        return ElevatedInnerSlopedPrismSkipPredicate.getTriDir(cmpDir, side).isEqualTo(ElevatedInnerPrismSkipPredicate.getTriDir(adjDirAxis, side.getOpposite()));
    }

    public static HalfDir getTriDir(CompoundDirection cmpDir, Direction side) {
        Direction dir = cmpDir.direction();
        Direction orientation = cmpDir.orientation();
        if (dir.getAxis() != orientation.getAxis() && side == orientation) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

