/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_POST})
public final class PostSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object;
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
        if (side.getAxis() == axis && (object = adjState.getBlock()) instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_POST -> PostSkipPredicate.testAgainstPost(axis, adjState);
                case BlockType.FRAMED_FENCE -> PostSkipPredicate.testAgainstFence(axis);
                case BlockType.FRAMED_LATTICE_BLOCK -> PostSkipPredicate.testAgainstLattice(axis, adjState);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(Direction.Axis axis, BlockState adjState) {
        return axis == adjState.getValue((Property)BlockStateProperties.AXIS);
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstFence(Direction.Axis axis) {
        return axis == Direction.Axis.Y;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(Direction.Axis axis, BlockState adjState) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> (Boolean)adjState.getValue((Property)FramedProperties.X_AXIS);
            case Direction.Axis.Y -> (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS);
            case Direction.Axis.Z -> (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS);
        };
    }
}

