/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.property;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum NullableDirection implements StringRepresentable
{
    NONE(null),
    DOWN(Direction.DOWN),
    UP(Direction.UP),
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST);

    private static final IntFunction<NullableDirection> BY_ID;
    public static final Codec<NullableDirection> CODEC;
    public static final StreamCodec<ByteBuf, NullableDirection> STREAM_CODEC;
    private final Direction dir;

    private NullableDirection(Direction dir) {
        this.dir = dir;
    }

    public Direction toDirection() {
        return this.dir;
    }

    public String getSerializedName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public static NullableDirection fromDirection(Direction dir) {
        if (dir == null) {
            return NONE;
        }
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])NullableDirection.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        CODEC = StringRepresentable.fromEnum(NullableDirection::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

