/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.property;

import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import xfacthd.framedblocks.api.util.Utils;

public enum CornerTubeOrientation implements StringRepresentable
{
    UP_NORTH(Direction.UP, Direction.NORTH),
    UP_EAST(Direction.UP, Direction.EAST),
    UP_SOUTH(Direction.UP, Direction.SOUTH),
    UP_WEST(Direction.UP, Direction.WEST),
    DOWN_NORTH(Direction.DOWN, Direction.NORTH),
    DOWN_EAST(Direction.DOWN, Direction.EAST),
    DOWN_SOUTH(Direction.DOWN, Direction.SOUTH),
    DOWN_WEST(Direction.DOWN, Direction.WEST),
    NORTH_EAST(Direction.NORTH, Direction.EAST),
    EAST_SOUTH(Direction.EAST, Direction.SOUTH),
    SOUTH_WEST(Direction.SOUTH, Direction.WEST),
    WEST_NORTH(Direction.WEST, Direction.NORTH);

    private static final CornerTubeOrientation[][] FROM_DIRS;
    public static final int COUNT;
    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final Direction primDir;
    private final Direction secDir;

    private CornerTubeOrientation(Direction primDir, Direction secDir) {
        this.primDir = primDir;
        this.secDir = secDir;
    }

    public Direction getPrimaryDir() {
        return this.primDir;
    }

    public Direction getSecondaryDir() {
        return this.secDir;
    }

    public boolean isVertical() {
        return Utils.isY(this.primDir);
    }

    public boolean isSideOpen(Direction side) {
        return side == this.primDir || side == this.secDir;
    }

    public CornerTubeOrientation rotate(Rotation rot) {
        if (rot == Rotation.NONE) {
            return this;
        }
        return CornerTubeOrientation.of(rot.rotate(this.primDir), rot.rotate(this.secDir));
    }

    public CornerTubeOrientation mirror(Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return this;
        }
        return CornerTubeOrientation.of(mirror.mirror(this.primDir), mirror.mirror(this.secDir));
    }

    public String getSerializedName() {
        return this.name;
    }

    public static CornerTubeOrientation of(Direction dirOne, Direction dirTwo) {
        CornerTubeOrientation orientationOne = FROM_DIRS[dirOne.ordinal()][dirTwo.ordinal()];
        CornerTubeOrientation orientationTwo = FROM_DIRS[dirTwo.ordinal()][dirOne.ordinal()];
        if (orientationOne == null && orientationTwo == null) {
            throw new IllegalArgumentException("Invalid direction pair! Primary dir: " + String.valueOf(dirOne) + ", Secondary dir: " + String.valueOf(dirTwo));
        }
        return Objects.requireNonNullElse(orientationOne, orientationTwo);
    }

    private static CornerTubeOrientation[][] makeDirTable() {
        CornerTubeOrientation[][] table = new CornerTubeOrientation[6][6];
        for (CornerTubeOrientation orientation : CornerTubeOrientation.values()) {
            Direction primDir = orientation.primDir;
            Direction secDir = orientation.secDir;
            table[primDir.ordinal()][secDir.ordinal()] = orientation;
        }
        return table;
    }

    static {
        FROM_DIRS = CornerTubeOrientation.makeDirTable();
        COUNT = CornerTubeOrientation.values().length;
    }
}

