/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.TriggerRegistrar;
import xfacthd.framedblocks.common.FBContent;

public final class CamoContainerFactories {
    private static final Map<Item, CamoContainerFactory<?>> APPLICATION_ITEMS = new IdentityHashMap();
    private static final List<FactoryPredicatePair> APPLICATION_PREDICATES = new ArrayList<FactoryPredicatePair>();
    private static final Map<Item, Set<CamoContainerFactory<?>>> REMOVAL_ITEMS = new Reference2ObjectOpenHashMap();
    private static final Map<CamoContainerFactory<?>, List<Predicate<ItemStack>>> REMOVAL_PREDICATES = new Reference2ObjectOpenHashMap();

    public static void registerCamoFactories() {
        FBContent.CAMO_CONTAINER_FACTORY_REGISTRY.entrySet().stream().map(Map.Entry::getValue).forEach(factory -> factory.registerTriggerItems(new TriggerRegistrarImpl((CamoContainerFactory<?>)factory)));
        TriggerRegistrarImpl fluidRegistrar = new TriggerRegistrarImpl((CamoContainerFactory)FBContent.FACTORY_FLUID.value());
        fluidRegistrar.registerApplicationPredicate(stack -> stack.getCapability(Capabilities.FluidHandler.ITEM) != null);
        fluidRegistrar.registerRemovalPredicate(stack -> stack.getCapability(Capabilities.FluidHandler.ITEM) != null);
        TriggerRegistrarImpl blockRegistrar = new TriggerRegistrarImpl((CamoContainerFactory)FBContent.FACTORY_BLOCK.value());
        blockRegistrar.registerApplicationPredicate(stack -> stack.getItem() instanceof BlockItem);
        blockRegistrar.registerRemovalPredicate(TriggerRegistrar.DEFAULT_REMOVAL);
    }

    @Nullable
    public static CamoContainerFactory<?> findCamoFactory(ItemStack stack) {
        BlockItem item;
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && (item = (BlockItem)item2).getBlock() instanceof IFramedBlock) {
            return null;
        }
        CamoContainerFactory<?> factory = APPLICATION_ITEMS.get(stack.getItem());
        if (factory == null) {
            for (FactoryPredicatePair pair : APPLICATION_PREDICATES) {
                if (!pair.predicate.test(stack)) continue;
                factory = pair.factory;
                break;
            }
        }
        return factory;
    }

    public static boolean isValidRemovalTool(CamoContainer<?, ?> container, ItemStack stack) {
        Set<CamoContainerFactory<?>> factories = REMOVAL_ITEMS.get(stack.getItem());
        if (factories != null && factories.contains(container.getFactory())) {
            return true;
        }
        List predicates = REMOVAL_PREDICATES.getOrDefault(container.getFactory(), List.of());
        if (!predicates.isEmpty()) {
            for (Predicate predicate : predicates) {
                if (!predicate.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    private CamoContainerFactories() {
    }

    private record TriggerRegistrarImpl(CamoContainerFactory<?> factory) implements TriggerRegistrar
    {
        @Override
        public void registerApplicationItem(Item item) {
            if (APPLICATION_ITEMS.containsKey(item)) {
                throw new IllegalArgumentException(String.format("Item %s is already registered!", item));
            }
            APPLICATION_ITEMS.put(item, this.factory);
        }

        @Override
        public void registerApplicationPredicate(Predicate<ItemStack> predicate) {
            APPLICATION_PREDICATES.add(new FactoryPredicatePair(predicate, this.factory));
        }

        @Override
        public void registerRemovalItem(Item item) {
            Set factories = REMOVAL_ITEMS.computeIfAbsent(item, $ -> new ReferenceOpenHashSet());
            if (factories.contains(this.factory)) {
                String factoryName = Objects.requireNonNull(FBContent.CAMO_CONTAINER_FACTORY_REGISTRY.getKey(this.factory)).toString();
                throw new IllegalArgumentException(String.format("Factory %s is already registered to item %s!", factoryName, item));
            }
            factories.add(this.factory);
        }

        @Override
        public void registerRemovalPredicate(Predicate<ItemStack> predicate) {
            REMOVAL_PREDICATES.computeIfAbsent(this.factory, $ -> new ArrayList()).add(predicate);
        }
    }

    private record FactoryPredicatePair(Predicate<ItemStack> predicate, CamoContainerFactory<?> factory) {
    }
}

