/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;

public final class FramingSawRecipeSerializer
implements RecipeSerializer<FramingSawRecipe> {
    private static final MapCodec<FramingSawRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("material").forGetter(FramingSawRecipe::getMaterialAmount), (App)FramingSawRecipeAdditive.CODEC.listOf().optionalFieldOf("additives").flatXmap(FramingSawRecipeSerializer::verifyAndMapAdditivesDecode, FramingSawRecipeSerializer::verifyAndMapAdditivesEncode).forGetter(FramingSawRecipe::getAdditives), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(FramingSawRecipe::getResult), (App)Codec.BOOL.optionalFieldOf("disabled").xmap(opt -> opt.orElse(false), flag -> flag != false ? Optional.of(true) : Optional.empty()).forGetter(FramingSawRecipe::isDisabled)).apply((Applicative)inst, FramingSawRecipe::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, FramingSawRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, FramingSawRecipe::getMaterialAmount, (StreamCodec)FramingSawRecipeAdditive.STREAM_CODEC.apply(ByteBufCodecs.list()), FramingSawRecipe::getAdditives, (StreamCodec)ItemStack.STREAM_CODEC, FramingSawRecipe::getResult, (StreamCodec)ByteBufCodecs.BOOL, FramingSawRecipe::isDisabled, FramingSawRecipe::new);

    public MapCodec<FramingSawRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, FramingSawRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static DataResult<List<FramingSawRecipeAdditive>> verifyAndMapAdditivesDecode(Optional<List<FramingSawRecipeAdditive>> additives) {
        if (additives.isPresent()) {
            List<FramingSawRecipeAdditive> list = additives.get();
            if (list.size() > 3) {
                int count = list.size();
                return DataResult.error(() -> "More than 3 additives are not supported, found " + count);
            }
            return DataResult.success(list);
        }
        return DataResult.success(List.of());
    }

    private static DataResult<Optional<List<FramingSawRecipeAdditive>>> verifyAndMapAdditivesEncode(List<FramingSawRecipeAdditive> additives) {
        if (additives.isEmpty()) {
            return DataResult.success(Optional.empty());
        }
        if (additives.size() > 3) {
            int count = additives.size();
            return DataResult.error(() -> "More than 3 additives are not supported, found " + count);
        }
        return DataResult.success(Optional.of(additives));
    }
}

