/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei.camo;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.common.compat.jei.JeiConstants;
import xfacthd.framedblocks.common.compat.jei.camo.CamoItemStackHelper;
import xfacthd.framedblocks.common.compat.jei.camo.JeiCamoApplicationRecipe;
import xfacthd.framedblocks.common.crafting.CamoApplicationRecipe;

public final class CamoCraftingHelper {
    private static final int MAX_CAMO_EXAMPLE_INGREDIENTS_COUNT = 100;
    private final CamoApplicationRecipe helperRecipe;
    private final Ingredient camoExamplesIngredient;
    private final Ingredient emptyFramesIngredient;
    private final Ingredient emptyDoubleFramesIngredient;
    private List<ItemStack> camoExamples = new ArrayList<ItemStack>();
    private List<ItemStack> emptyFramedBlocks = new ArrayList<ItemStack>();
    private List<ItemStack> emptyDoubleFramedBlocks = new ArrayList<ItemStack>();

    public CamoCraftingHelper() {
        this.helperRecipe = Objects.requireNonNullElseGet(CamoCraftingHelper.findCanonicalRecipe(), () -> {
            FramedBlocks.LOGGER.warn("Failed to retrieve canonical CamoApplicationRecipe, using dummy");
            return new CamoApplicationRecipe(CraftingBookCategory.MISC, Ingredient.of((ItemLike[])new ItemLike[]{Items.BRUSH}));
        });
        this.camoExamplesIngredient = Ingredient.of(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG);
        this.emptyFramesIngredient = Ingredient.of(JeiConstants.ALL_FRAMES_TAG);
        this.emptyDoubleFramesIngredient = Ingredient.of(JeiConstants.DOUBLE_FRAMES_TAG);
    }

    @Nullable
    private static CamoApplicationRecipe findCanonicalRecipe() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        return level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(CamoApplicationRecipe.class::isInstance).map(CamoApplicationRecipe.class::cast).findFirst().orElse(null);
    }

    public Ingredient getCopyToolIngredient() {
        return this.helperRecipe.getCopyTool();
    }

    public void scanForItems(IIngredientManager ingredientManager) {
        ArrayList<ItemStack> camoExamples = new ArrayList<ItemStack>();
        ArrayList<ItemStack> emptyFramedBlocks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> emptyDoubleFramedBlocks = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredientManager.getAllItemStacks()) {
            CamoContainerFactory<?> factory;
            if (camoExamples.size() < 100 && (factory = CamoItemStackHelper.getCamoContainerFactory(stack)) != null) {
                camoExamples.add(stack);
            }
            if (!CamoItemStackHelper.isEmptyFramedBlock(stack)) continue;
            emptyFramedBlocks.add(stack);
            if (!CamoItemStackHelper.isDoubleFramedBlock(stack)) continue;
            emptyDoubleFramedBlocks.add(stack);
        }
        this.camoExamples = camoExamples;
        this.emptyFramedBlocks = List.copyOf(emptyFramedBlocks);
        this.emptyDoubleFramedBlocks = List.copyOf(emptyDoubleFramedBlocks);
    }

    public List<ItemStack> getEmptyFramedBlocks() {
        return this.emptyFramedBlocks;
    }

    public ItemStack calculateOutput(ItemStack frame, ItemStack inputOne, ItemStack inputTwo) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        assert (level != null);
        RegistryAccess registryAccess = level.registryAccess();
        Ingredient copyTool = this.helperRecipe.getCopyTool();
        ItemStack copyToolItem = copyTool.getItems()[0];
        List<ItemStack> inputs = List.of(frame, copyToolItem, inputOne, inputTwo);
        CraftingInput craftingInput = CraftingInput.of((int)2, (int)2, inputs);
        return this.helperRecipe.assemble(craftingInput, (HolderLookup.Provider)registryAccess);
    }

    private List<ItemStack> getCamoExampleStacks(Ingredient ingredient, int count) {
        if (ingredient.equals((Object)this.camoExamplesIngredient)) {
            Collections.shuffle(this.camoExamples);
            if (count < this.camoExamples.size()) {
                return new ArrayList<ItemStack>(this.camoExamples.subList(0, count));
            }
            return new ArrayList<ItemStack>(this.camoExamples);
        }
        return Arrays.asList(ingredient.getItems());
    }

    private List<ItemStack> getDoubleCamoExampleStacks(Ingredient ingredient, int count) {
        if (ingredient.equals((Object)this.camoExamplesIngredient)) {
            Collections.shuffle(this.camoExamples);
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            results.add(ItemStack.EMPTY);
            if (--count < this.camoExamples.size()) {
                results.addAll(this.camoExamples.subList(0, count));
            } else {
                results.addAll(this.camoExamples);
            }
            return results;
        }
        return Arrays.asList(ingredient.getItems());
    }

    private List<ItemStack> getEmptyFrameStacks(Ingredient ingredient) {
        if (ingredient.equals((Object)this.emptyFramesIngredient)) {
            return this.emptyFramedBlocks;
        }
        if (ingredient.equals((Object)this.emptyDoubleFramesIngredient)) {
            return this.emptyDoubleFramedBlocks;
        }
        return Arrays.asList(ingredient.getItems());
    }

    public void setRecipe(JeiCamoApplicationRecipe recipe, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper) {
        List<Pair> namedInputs = List.of(Pair.of((Object)"frames", this.getEmptyFrameStacks(recipe.getFrame())), Pair.of((Object)"copyTool", Arrays.asList(recipe.getCopyTool().getItems())), Pair.of((Object)"camoOne", this.getCamoExampleStacks(recipe.getCamoOne(), 97)), Pair.of((Object)"camoTwo", this.getDoubleCamoExampleStacks(recipe.getCamoTwo(), 11)));
        List inputSlots = craftingGridHelper.createAndSetNamedInputs(builder, namedInputs, 2, 2);
        InputSlotTooltipCallback tooltipCallback = new InputSlotTooltipCallback();
        for (IRecipeSlotBuilder slotBuilder : inputSlots) {
            slotBuilder.addRichTooltipCallback((IRecipeSlotRichTooltipCallback)tooltipCallback);
        }
        List<ItemStack> results = recipe.getResults();
        if (results.isEmpty()) {
            List frameStacks = (List)namedInputs.get(0).getSecond();
            List camoStackOne = (List)namedInputs.get(2).getSecond();
            List camoStackTwo = (List)namedInputs.get(3).getSecond();
            ItemStack firstOutput = this.calculateOutput(frameStacks.isEmpty() ? ItemStack.EMPTY : (ItemStack)frameStacks.getFirst(), camoStackOne.isEmpty() ? ItemStack.EMPTY : (ItemStack)camoStackOne.getFirst(), camoStackTwo.isEmpty() ? ItemStack.EMPTY : (ItemStack)camoStackTwo.getFirst());
            results = List.of(firstOutput);
        }
        craftingGridHelper.createAndSetOutputs(builder, results);
    }

    private static class InputSlotTooltipCallback
    implements IRecipeSlotRichTooltipCallback {
        private InputSlotTooltipCallback() {
        }

        public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
            recipeSlotView.getSlotName().ifPresent(name -> {
                if ((name.equals("camoOne") || name.equals("camoTwo")) && recipeSlotView.getItemStacks().count() > 1L) {
                    tooltip.clear();
                    tooltip.add((FormattedText)JeiConstants.MSG_SUPPORTS_MOST_CAMOS);
                }
            });
        }
    }
}

