/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ItemStackElement;
import xfacthd.framedblocks.common.blockentity.special.FramedItemFrameBlockEntity;
import xfacthd.framedblocks.common.compat.jade.JadeCompat;

final class FramedItemFrameComponentProvider
implements IBlockComponentProvider {
    static final FramedItemFrameComponentProvider INSTANCE = new FramedItemFrameComponentProvider();

    private FramedItemFrameComponentProvider() {
    }

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        FramedItemFrameBlockEntity be;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof FramedItemFrameBlockEntity && (be = (FramedItemFrameBlockEntity)blockEntity).hasItem()) {
            return ItemStackElement.of((ItemStack)be.getItem());
        }
        return null;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig config) {
        FramedItemFrameBlockEntity be;
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof FramedItemFrameBlockEntity && (be = (FramedItemFrameBlockEntity)blockEntity).hasItem()) {
            tooltip.add((Component)IDisplayHelper.get().stripColor(be.getItem().getHoverName()));
        }
    }

    public ResourceLocation getUid() {
        return JadeCompat.ID_ITEM_FRAME;
    }
}

